/*
 * Decompiled with CFR 0.152.
 */
package netdecoder;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Serialization {
    public static <T> void serialize(T objectToSerialize, String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("Name of file to which to serialize object to cannot be null.");
        }
        if (objectToSerialize == null) {
            throw new IllegalArgumentException("Object to be serialized cannot be null.");
        }
        try (FileOutputStream fos = new FileOutputStream(fileName);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(objectToSerialize);
        }
        catch (IOException ioException) {
            System.err.println("Serialization of an object of class " + objectToSerialize.getClass().getName() + " to " + fileName + " failed.");
            ioException.printStackTrace();
            System.exit(1);
        }
    }

    public static <T> T deserialize(String fileToDeserialize, Class<T> classBeingDeserialized) {
        if (fileToDeserialize == null) {
            throw new IllegalArgumentException("Cannot deserialize from a null filename.");
        }
        if (classBeingDeserialized == null) {
            throw new IllegalArgumentException("Type of class to be deserialized cannot be null.");
        }
        Object objectOut = null;
        try (FileInputStream fis = new FileInputStream(fileToDeserialize);
             ObjectInputStream ois = new ObjectInputStream(fis);){
            objectOut = ois.readObject();
        }
        catch (IOException | ClassNotFoundException exception) {
            System.err.println("Deserialization of " + fileToDeserialize + " to an object of class " + classBeingDeserialized.getName() + " failed.");
            exception.printStackTrace();
            System.exit(1);
        }
        return (T)objectOut;
    }
}

