/*
 * Decompiled with CFR 0.152.
 */
package netdecoder;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import org.rosuda.JRI.Rengine;

public class RJava {
    Rengine re;

    public void plotDistribution(String filename, String title) {
        String file = "'" + filename + ".txt'";
        String write_1 = "'" + filename + ".pdf" + "'";
        this.re.eval("df <- read.table(" + file + ", sep='\t', header = TRUE)");
        this.re.eval("df <- data.frame(condition=df$flows)");
        this.re.eval("pdf(file=" + write_1 + ", width=2, height=2);");
        this.re.eval("figure <- ggplot(df, aes(x=condition)) + xlim(0, 1) + geom_histogram(binwidth=0.1, alpha=0.7, colour=\"white\", fill=\"black\") +  xlab(\"Edge flow\") + ylab(\"Number of edges\") + theme_bw() + theme(panel.grid = element_blank(), panel.border=element_blank(), axis.line = element_line(colour = \"black\"), axis.title=element_text(size=10)) + theme(axis.text.x = element_text(size=8, angle=0, hjust=1), axis.text.y = element_text(size=8, hjust=1)) + ggtitle('" + title + "'" + ")");
        this.re.eval("plot(figure)");
        this.re.eval("dev.off()");
    }

    public void exportGML(String filename_subnet, String filename_totalFlow, String filename_differences) {
        String file_subnet = "'" + filename_subnet + ".txt'";
        String file_flowDifference = "'" + filename_differences + ".txt'";
        String file_totalFlow = "'" + filename_totalFlow + ".txt'";
        String write_1 = "'" + filename_subnet + ".gml" + "'";
        this.re.eval("subnet <- read.table(" + file_subnet + ", sep='\t', header = TRUE)");
        this.re.eval("data <- read.table(" + file_flowDifference + ", sep='\t', header = TRUE)");
        this.re.eval("totalFlow <- read.table(" + file_totalFlow + ", sep='\t', header = TRUE)");
        this.re.eval("colnames(subnet) <- c('from', 'to', 'weight', 'correlation', 'sign')");
        this.re.eval("iG <- graph.data.frame(subnet, directed=TRUE)");
        this.re.eval("V(iG)$label <- V(iG)$name");
        this.re.eval("xcols <- colfunc<-colorRampPalette(c(\"blue\", \"white\", \"red\"))");
        this.re.eval("xcols <- xcols(length(data$flows))");
        this.re.eval("mycols<-rep('', length(data$flows));");
        this.re.eval("mycols[order(data$flows)]<-xcols;");
        this.re.eval("V(iG)[as.vector(data$gene)]$colors <- mycols");
        this.re.eval("V(iG)[as.vector(data$gene)]$diffs <- data$flows");
        this.re.eval("V(iG)[as.vector(totalFlow$gene)]$totalFlows <- totalFlow$flows");
        this.re.eval("V(iG)$degree <- igraph::degree(iG)");
        this.re.eval("neighS <- V(induced.subgraph(graph=iG,vids=unlist(neighborhood(graph=iG,order=1,nodes='s'))))$name");
        this.re.eval("neighT <- V(induced.subgraph(graph=iG,vids=unlist(neighborhood(graph=iG,order=1,nodes='t'))))$name");
        this.re.eval("V(iG)$props = rep(\"PROTEIN\", length(V(iG)$name))");
        this.re.eval("V(iG)[match(neighS, V(iG)$name)]$props = \"SOURCE\";");
        this.re.eval("V(iG)[match(neighT, V(iG)$name)]$props = \"TARGET\";");
        this.re.eval("iG2 <- delete.vertices(iG, c('s','t'))");
        this.re.eval("write.graph(iG2," + write_1 + ", format = 'gml')");
    }

    public void exportGML2(String filename_subnet, String filename_totalFlow, String filename_differences) {
        String file_subnet = "'" + filename_subnet + ".txt'";
        String file_flowDifference = "'" + filename_differences + ".txt'";
        String file_totalFlow = "'" + filename_totalFlow + ".txt'";
        String write_1 = "'" + filename_subnet + ".gml" + "'";
        this.re.eval("subnet <- read.table(" + file_subnet + ", sep='\t', header = TRUE)");
        this.re.eval("data <- read.table(" + file_flowDifference + ", sep='\t', header = TRUE)");
        this.re.eval("totalFlow <- read.table(" + file_totalFlow + ", sep='\t', header = TRUE)");
        this.re.eval("colnames(subnet) <- c('from', 'to', 'weight', 'correlation', 'sign')");
        this.re.eval("iG <- graph.data.frame(subnet, directed=TRUE)");
        this.re.eval("V(iG)$label <- V(iG)$name");
        this.re.eval("xcols <- colfunc<-colorRampPalette(c(\"blue\", \"white\", \"red\"))");
        this.re.eval("xcols <- xcols(length(data$flows))");
        this.re.eval("mycols<-rep('', length(data$flows));");
        this.re.eval("mycols[order(data$flows)]<-xcols;");
        this.re.eval("V(iG)[as.vector(data$gene)]$colors <- mycols");
        this.re.eval("V(iG)[as.vector(data$gene)]$diffs <- data$flows");
        this.re.eval("V(iG)[as.vector(totalFlow$gene)]$totalFlows <- totalFlow$flows");
        this.re.eval("V(iG)$degree <- igraph::degree(iG)");
        this.re.eval("write.graph(iG," + write_1 + ", format = 'gml')");
    }

    public void plotHeatmapSH(String name, String disease, int threshold, String type, String filename) {
        String file = "'" + name + ".txt'";
        String write_1 = "'" + filename + "_" + type + ".pdf" + "'";
        String write_2 = "'" + filename + "_" + type + "_TOP.txt" + "'";
        System.out.println("saving heatmaps...");
        String title = type;
        this.re.eval("data <- read.table(" + file + ", sep='\t', header = TRUE)");
        this.re.eval("rownames(data) <- as.vector(data$X)");
        this.re.eval("data <- data[,c(2, 3)]");
        this.re.eval("colnames(data) <- c('control','" + disease + "'" + ")");
        this.re.eval("data <- log2(data + 1)");
        this.re.eval("data <- data[order(data$" + disease + ", decreasing=TRUE),]");
        this.re.eval("top<-" + threshold);
        this.re.eval("data <- data[1:top,]");
        this.re.eval("aux <- data");
        this.re.eval("aux$gene <- rownames(aux)");
        this.re.eval("aux <- aux[,c('gene', 'control', '" + disease + "'" + ")]");
        this.re.eval("write.table(aux, file=" + write_2 + ", row.names=FALSE, col.names=TRUE, sep='\t')");
        this.re.eval("df <- data");
        this.re.eval("df$genes <- rownames(df)");
        this.re.eval("matrix.m <- melt(df, id=c(\"genes\"))");
        this.re.eval("matrix.m$genes <- factor(matrix.m$genes, levels=matrix.m[order(matrix.m$value, decreasing=TRUE), \"genes\"])");
        this.re.eval("range <- range(matrix.m$value)");
        this.re.eval("pdf(file=" + write_1 + ", width=2.5, height=3.5);");
        this.re.eval("figure <- ggplot(matrix.m, aes(variable, genes)) + geom_tile(aes(fill = value), colour = \"black\") + scale_fill_gradient2(\"log2\n(total flow)\", limits=range, low=\"white\", high=\"red\", guide=\"colorbar\") + theme_bw() + xlab(\"\") + ylab(\"\") + theme(legend.key.size = unit(0.3, \"cm\"), panel.grid=element_blank(), panel.border=element_blank(),legend.position=\"right\", legend.direction=\"vertical\") + theme(axis.text.x = element_text(size=rel(0.75), angle=45, hjust=1), axis.text.y = element_text(size = rel(0.75), angle = 00)) + ggtitle('" + title + "'" + ")");
        this.re.eval("print(figure)");
        this.re.eval("dev.off()");
    }

    public void plotHeatmapSH2(String name, String disease, int threshold, String type, String filename) {
        String file = "'" + name + ".txt'";
        String write_1 = "'" + filename + "_" + type + ".pdf" + "'";
        System.out.println("saving heatmaps...");
        String title = type;
        this.re.eval("df <- read.table(" + file + ", sep='\t', header = TRUE)");
        this.re.eval("matrix.m <- melt(df, id=c('gene'))");
        this.re.eval("matrix.m$gene <- factor(matrix.m$gene, levels=matrix.m[order(matrix.m$value, decreasing=FALSE), 'gene'])");
        this.re.eval("range <- range(matrix.m$value)");
        this.re.eval("pdf(file=" + write_1 + ", width=2.3, height=3.5);");
        this.re.eval("figure <- ggplot(matrix.m, aes(variable, gene)) + geom_tile(aes(fill = value), colour = \"black\") + scale_fill_gradient2(\"flow\ndifference\", limits=range, low=\"blue\", high=\"red\", guide=\"colorbar\") + theme_bw() + xlab(\"\") + ylab(\"\") + theme(legend.key.size = unit(0.3, \"cm\"), panel.grid=element_blank(), panel.border=element_blank(),legend.position=\"right\", legend.direction=\"vertical\") + theme(axis.text.x = element_text(size=rel(0.75), angle=45, hjust=1), axis.text.y = element_text(size = rel(0.75), angle = 00)) + ggtitle('" + title + "'" + ")");
        this.re.eval("print(figure)");
        this.re.eval("dev.off()");
    }

    public void plotVennImpactScore(String dir, String nameControl, String nameDisease, String condition, String filename) {
        String fileControl = "'" + dir + nameControl + "'";
        String fileDisease = "'" + dir + nameDisease + ".txt'";
        String write_1 = "'" + dir + filename + ".pdf" + "'";
        System.out.println("saving Venn diagrams...");
        this.re.eval("control <- read.table(" + fileControl + ", sep='\t', header = TRUE)");
        this.re.eval("disease <- read.table(" + fileDisease + ", sep='\t', header = TRUE)");
        this.re.eval("colnames(disease) <- c('expression', 'genes', 'CSS')");
        this.re.eval("venn <- list()");
        this.re.eval("venn[['candidate genes']] <- as.vector(control$genes)");
        this.re.eval("venn[['" + condition + "'" + "]] <- as.vector(disease$genes)");
        this.re.eval("venTF <- Venn(venn);");
        this.re.eval("pdf(file=" + write_1 + ", width=3, height=3)");
        this.re.eval("plot(venTF,doWeights=FALSE)");
        this.re.eval("dev.off()");
    }

    public void plotVennGenesPaths(String dir, String nameControl, String nameDisease, String condition, String type, String filename) {
        String fileControl = "'" + nameControl + ".txt'";
        String fileDisease = "'" + nameDisease + ".txt'";
        String write_1 = "'" + dir + filename + ".pdf" + "'";
        System.out.println("saving Venn diagrams...");
        this.re.eval("control <- read.table(" + fileControl + ", sep='\t', header = TRUE)");
        this.re.eval("disease <- read.table(" + fileDisease + ", sep='\t', header = TRUE)");
        this.re.eval("venn <- list()");
        this.re.eval("venn[['control']] <- as.vector(control$" + type + ")");
        this.re.eval("venn[['" + condition + "'" + "]] <- as.vector(disease$" + type + ")");
        this.re.eval("venTF <- Venn(venn);");
        this.re.eval("pdf(file=" + write_1 + ", width=3, height=3)");
        this.re.eval("plot(venTF,doWeights=FALSE)");
        this.re.eval("dev.off()");
    }

    public void plotVennEdges(String dir, String nameControl, String nameDisease, String condition, String filename) {
        String fileControl = "'" + nameControl + ".txt'";
        String fileDisease = "'" + nameDisease + ".txt'";
        String write_1 = "'" + dir + filename + ".pdf" + "'";
        System.out.println("saving Venn diagrams...");
        this.re.eval("control <- read.table(" + fileControl + ", sep='\t', header = TRUE)");
        this.re.eval("disease <- read.table(" + fileDisease + ", sep='\t', header = TRUE)");
        this.re.eval("control$edge <- paste(control$from, control$to, sep='->')");
        this.re.eval("disease$edge <- paste(disease$from, disease$to, sep='->')");
        this.re.eval("venn <- list()");
        this.re.eval("venn[['control']] <- as.vector(control$edge)");
        this.re.eval("venn[['" + condition + "'" + "]] <- as.vector(disease$edge)");
        this.re.eval("venTF <- Venn(venn);");
        this.re.eval("pdf(file=" + write_1 + ", width=3, height=3)");
        this.re.eval("plot(venTF,doWeights=FALSE)");
        this.re.eval("dev.off()");
    }

    public String createDistributionScript(String filename, String title) {
        String scriptName = filename + "_distribution.R";
        String file = "'" + filename + ".txt'";
        String write_1 = "'" + filename + ".pdf" + "'";
        try {
            File f = new File(scriptName);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("library(gplots);\n");
            bw.write("library(ggplot2);\n");
            bw.write("library(grid); \n");
            bw.write("library(reshape); \n");
            bw.write("library(reshape2); \n");
            bw.write("library(plyr); \n");
            bw.write("library(RColorBrewer); \n");
            bw.write("library(igraph); \n");
            bw.write("library(Vennerable); \n");
            bw.write("df <- read.table(" + file + ", sep='\t', header = TRUE); \n");
            bw.write("df <- data.frame(condition=df$flows); \n");
            bw.write("pdf(file=" + write_1 + ", width=2, height=2); \n");
            bw.write("figure <- ggplot(df, aes(x=condition)) + xlim(0, 1) + geom_histogram(binwidth=0.1, alpha=0.7, colour=\"white\", fill=\"black\") +  xlab(\"Edge flow\") + ylab(\"Number of edges\") + theme_bw() + theme(panel.grid = element_blank(), panel.border=element_blank(), axis.line = element_line(colour = \"black\"), axis.title=element_text(size=10)) + theme(axis.text.x = element_text(size=8, angle=0, hjust=1), axis.text.y = element_text(size=8, hjust=1)) + ggtitle('" + title + "'" + "); \n");
            bw.write("plot(figure); \n");
            bw.write("dev.off(); \n");
            bw.write("#--------------------------------------------------------------------------\n");
            bw.close();
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
        return scriptName;
    }

    public String createScriptExportGML2(String filename_subnet, String filename_totalFlow, String filename_differences) {
        String scriptName = filename_subnet + ".R";
        String file_subnet = "'" + filename_subnet + ".txt'";
        String file_flowDifference = "'" + filename_differences + ".txt'";
        String file_totalFlow = "'" + filename_totalFlow + ".txt'";
        String write_1 = "'" + filename_subnet + ".gml" + "'";
        try {
            File f = new File(scriptName);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("library(gplots);\n");
            bw.write("library(ggplot2);\n");
            bw.write("library(grid); \n");
            bw.write("library(reshape); \n");
            bw.write("library(reshape2); \n");
            bw.write("library(plyr); \n");
            bw.write("library(RColorBrewer); \n");
            bw.write("library(igraph); \n");
            bw.write("library(Vennerable); \n");
            bw.write("subnet <- read.table(" + file_subnet + ", sep='\t', header = TRUE); \n");
            bw.write("data <- read.table(" + file_flowDifference + ", sep='\t', header = TRUE); \n");
            bw.write("print (data); \n");
            bw.write("totalFlow <- read.table(" + file_totalFlow + ", sep='\t', header = TRUE); \n");
            bw.write("colnames(subnet) <- c('from', 'to', 'weight', 'correlation', 'sign'); \n");
            bw.write("iG <- graph.data.frame(subnet, directed=TRUE); \n");
            bw.write("V(iG)$label <- V(iG)$name; \n");
            bw.write("xcols <- colfunc<-colorRampPalette(c(\"blue\", \"white\", \"red\")); \n");
            bw.write("xcols <- xcols(length(as.numeric(data$flows))); \n");
            bw.write("mycols<-rep('', length(as.numeric(data$flows))); \n");
            bw.write("mycols[order(as.numeric(data$flows))]<-xcols; \n");
            bw.write("V(iG)[as.vector(data$gene)]$colors <- mycols; \n");
            bw.write("V(iG)[as.vector(data$gene)]$diffs <- as.numeric(data$flows); \n");
            bw.write("V(iG)[as.vector(totalFlow$gene)]$totalFlows <- as.numeric(totalFlow$flows); \n");
            bw.write("V(iG)$degree <- igraph::degree(iG); \n");
            bw.write("write.graph(iG," + write_1 + ", format = 'gml'); \n");
            bw.write("#--------------------------------------------------------------------------\n");
            bw.close();
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
        return scriptName;
    }

    public String createHeatmapSH2Script(String name, String disease, int threshold, String type, String filename) {
        String scriptName = filename + "_" + type + "_heatmapSH.R";
        String file = "'" + name + ".txt'";
        String write_1 = "'" + filename + "_" + type + ".pdf" + "'";
        System.out.println("saving heatmaps...");
        String title = type;
        try {
            File f = new File(scriptName);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("library(gplots);\n");
            bw.write("library(ggplot2);\n");
            bw.write("library(grid); \n");
            bw.write("library(reshape); \n");
            bw.write("library(reshape2); \n");
            bw.write("library(plyr); \n");
            bw.write("library(RColorBrewer); \n");
            bw.write("library(igraph); \n");
            bw.write("library(Vennerable); \n");
            bw.write("df <- read.table(" + file + ", sep='\t', header = TRUE); \n");
            bw.write("matrix.m <- melt(df, id=c('gene')); \n");
            bw.write("matrix.m$gene <- factor(matrix.m$gene, levels=matrix.m[order(matrix.m$value, decreasing=FALSE), 'gene']); \n");
            bw.write("range <- range(matrix.m$value); \n");
            bw.write("pdf(file=" + write_1 + ", width=2.3, height=3.5);\n");
            bw.write("figure <- ggplot(matrix.m, aes(variable, gene)) + geom_tile(aes(fill = value), colour = \"black\") + scale_fill_gradient2(\"flow\ndifference\", limits=range, low=\"blue\", high=\"red\", guide=\"colorbar\") + theme_bw() + xlab(\"\") + ylab(\"\") + theme(legend.key.size = unit(0.3, \"cm\"), panel.grid=element_blank(), panel.border=element_blank(),legend.position=\"right\", legend.direction=\"vertical\") + theme(axis.text.x = element_text(size=rel(0.75), angle=45, hjust=1), axis.text.y = element_text(size = rel(0.75), angle = 00)) + ggtitle('" + title + "'" + "); \n");
            bw.write("print(figure); \n");
            bw.write("dev.off(); \n");
            bw.write("#--------------------------------------------------------------------------\n");
            bw.close();
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
        return scriptName;
    }

    public String createJaccardMatrixScript(String filename) {
        String scriptName = filename + "_jaccardMatrix.R";
        String file = "'" + filename + ".txt" + "'";
        String write = "'" + filename + ".pdf" + "'";
        System.out.println("saving Jaccard index heatmap...");
        try {
            File f = new File(scriptName);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("library(gplots);\n");
            bw.write("library(ggplot2);\n");
            bw.write("library(grid); \n");
            bw.write("library(reshape); \n");
            bw.write("library(reshape2); \n");
            bw.write("library(plyr); \n");
            bw.write("library(RColorBrewer); \n");
            bw.write("library(igraph); \n");
            bw.write("library(Vennerable); \n");
            bw.write("sim <- read.csv(" + file + ", sep='\t'); \n");
            bw.write("names <- as.vector(sim$X); \n");
            bw.write("sim <- sim[,2:dim(sim)[2]]; \n");
            bw.write("rownames(sim) <- names; \n");
            bw.write("hmcols<- colorRampPalette(c(\"black\", \"yellow\")); \n");
            bw.write("pdf(file=" + write + ", width=5, height=5); \n");
            bw.write("heatmap.2(as.matrix(t(sim)), col=hmcols,trace=\"none\", density.info=\"none\", scale=\"none\",margin=c(15,15), key=TRUE, Rowv=T, Colv=T,srtCol=60, dendrogram=\"none\", cexCol=0.55, cexRow=0.55, symm=T,  sepcolor='black'); \n");
            bw.write("dev.off(); \n");
            bw.write("#--------------------------------------------------------------------------\n");
            bw.close();
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
        return scriptName;
    }

    public String createAdjAdjMatrixScript(String dir, String filename, String gene) {
        String scriptName = dir + filename + "_adjMatrix.R";
        String file = "'" + dir + filename + ".txt" + "'";
        String write = "'" + dir + filename + ".pdf" + "'";
        System.out.println("saving adjacency matrices...");
        try {
            File f = new File(scriptName);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("library(gplots);\n");
            bw.write("library(ggplot2);\n");
            bw.write("library(grid); \n");
            bw.write("library(reshape); \n");
            bw.write("library(reshape2); \n");
            bw.write("library(plyr); \n");
            bw.write("library(RColorBrewer); \n");
            bw.write("library(igraph); \n");
            bw.write("library(Vennerable); \n");
            bw.write("matrix <- read.csv(" + file + ", sep='\t'); \n");
            bw.write("rownames(matrix) <- matrix$gene; \n");
            bw.write("matrix <- matrix[, 2:dim(matrix)[2]]; \n");
            bw.write("matrix[row(matrix) > col(matrix)] <- 0.5; \n");
            bw.write("diag(matrix) <- 0.5; \n");
            bw.write("matrix <- data.frame(gene=rownames(matrix), matrix); \n");
            bw.write("matrix.m <- melt(matrix, id.var='gene'); \n");
            bw.write("matrix.m <- na.omit(matrix.m); \n");
            bw.write("matrix.m$gene <- factor(matrix.m$gene, levels=matrix.m$gene); \n");
            bw.write("matrix.m$variable <- factor(matrix.m$variable, levels=rev(levels(matrix.m$gene))); \n");
            bw.write("matrix.m <- ddply(matrix.m, .(variable), transform, rescale = value); \n");
            bw.write("w=dim(matrix)[1] / 2.5; \n");
            bw.write("h=dim(matrix)[2] / 3; \n");
            bw.write("pdf(file=" + write + ", width=w, height=h); \n");
            bw.write("figure <- ggplot(matrix.m, aes(gene, variable)) + geom_tile(aes(fill = value), colour = 'black') + scale_fill_gradient(low = 'white', high = 'red') + theme_bw() + xlab('') + ylab('') + theme(panel.grid=element_blank(), panel.border=element_blank(), legend.position='none', axis.text.x = element_text(size=rel(1), angle=45, hjust=1),axis.title.y = element_text(size = rel(0.3), angle = 90)) + ggtitle('" + gene + "'" + "); \n");
            bw.write("print(figure); \n");
            bw.write("dev.off(); \n");
            bw.write("#--------------------------------------------------------------------------\n");
            bw.close();
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
        return scriptName;
    }

    public String createVennEdgesScript(String dir, String nameControl, String nameDisease, String condition, String filename) {
        String scriptName = dir + filename + "_vennDiagramsEdges.R";
        String fileControl = "'" + nameControl + ".txt'";
        String fileDisease = "'" + nameDisease + ".txt'";
        String write_1 = "'" + dir + filename + ".pdf" + "'";
        System.out.println("saving Venn diagrams...");
        try {
            File f = new File(scriptName);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("library(gplots);\n");
            bw.write("library(ggplot2);\n");
            bw.write("library(grid); \n");
            bw.write("library(reshape); \n");
            bw.write("library(reshape2); \n");
            bw.write("library(plyr); \n");
            bw.write("library(RColorBrewer); \n");
            bw.write("library(igraph); \n");
            bw.write("library(Vennerable); \n");
            bw.write("control <- read.table(" + fileControl + ", sep='\t', header = TRUE); \n");
            bw.write("disease <- read.table(" + fileDisease + ", sep='\t', header = TRUE); \n");
            bw.write("control$edge <- paste(control$from, control$to, sep='->'); \n");
            bw.write("disease$edge <- paste(disease$from, disease$to, sep='->'); \n");
            bw.write("venn <- list(); \n");
            bw.write("venn[['control']] <- as.vector(control$edge); \n");
            bw.write("venn[['" + condition + "'" + "]] <- as.vector(disease$edge); \n");
            bw.write("venTF <- Venn(venn); \n");
            bw.write("pdf(file=" + write_1 + ", width=3, height=3); \n");
            bw.write("plot(venTF,doWeights=FALSE); \n");
            bw.write("dev.off(); \n");
            bw.write("#--------------------------------------------------------------------------\n");
            bw.close();
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
        return scriptName;
    }

    public String createVennGenesPathsScript(String dir, String nameControl, String nameDisease, String condition, String type, String filename) {
        String scriptName = dir + filename + "_vennDiagramsGenesPaths.R";
        String fileControl = "'" + nameControl + ".txt'";
        String fileDisease = "'" + nameDisease + ".txt'";
        String write_1 = "'" + dir + filename + ".pdf" + "'";
        System.out.println("saving Venn diagrams...");
        try {
            File f = new File(scriptName);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("library(gplots);\n");
            bw.write("library(ggplot2);\n");
            bw.write("library(grid); \n");
            bw.write("library(reshape); \n");
            bw.write("library(reshape2); \n");
            bw.write("library(plyr); \n");
            bw.write("library(RColorBrewer); \n");
            bw.write("library(igraph); \n");
            bw.write("library(Vennerable); \n");
            bw.write("control <- read.table(" + fileControl + ", sep='\t', header = TRUE); \n");
            bw.write("disease <- read.table(" + fileDisease + ", sep='\t', header = TRUE); \n");
            bw.write("venn <- list(); \n");
            bw.write("venn[['control']] <- as.vector(control$" + type + "); \n");
            bw.write("venn[['" + condition + "'" + "]] <- as.vector(disease$" + type + "); \n");
            bw.write("venTF <- Venn(venn); \n");
            bw.write("pdf(file=" + write_1 + ", width=3, height=3); \n");
            bw.write("plot(venTF,doWeights=FALSE); \n");
            bw.write("dev.off(); \n");
            bw.write("#--------------------------------------------------------------------------\n");
            bw.close();
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
        return scriptName;
    }

    public String createScriptExportGML(String filename_subnet, String filename_totalFlow, String filename_differences) {
        String scriptName = filename_subnet + "_exportGML1.R";
        String file_subnet = "'" + filename_subnet + ".txt'";
        String file_flowDifference = "'" + filename_differences + ".txt'";
        String file_totalFlow = "'" + filename_totalFlow + ".txt'";
        String write_1 = "'" + filename_subnet + ".gml" + "'";
        try {
            File f = new File(scriptName);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("library(gplots);\n");
            bw.write("library(ggplot2);\n");
            bw.write("library(grid); \n");
            bw.write("library(reshape); \n");
            bw.write("library(reshape2); \n");
            bw.write("library(plyr); \n");
            bw.write("library(RColorBrewer); \n");
            bw.write("library(igraph); \n");
            bw.write("library(Vennerable); \n");
            bw.write("subnet <- read.table(" + file_subnet + ", sep='\t', header = TRUE);\n");
            bw.write("data <- read.table(" + file_flowDifference + ", sep='\t', header = TRUE);\n");
            bw.write("totalFlow <- read.table(" + file_totalFlow + ", sep='\t', header = TRUE);\n");
            bw.write("colnames(subnet) <- c('from', 'to', 'weight', 'correlation', 'sign');\n");
            bw.write("if(nrow(subnet) > 0){ \n");
            bw.write("iG <- graph.data.frame(subnet, directed=TRUE);\n");
            bw.write("V(iG)$label <- V(iG)$name;\n");
            bw.write("xcols <- colfunc<-colorRampPalette(c(\"blue\", \"white\", \"red\"));\n");
            bw.write("xcols <- colfunc<-colorRampPalette(c(\"white\", \"red\"));\n");
            bw.write("xcols <- xcols(length(data$flows));\n");
            bw.write("mycols<-rep('', length(data$flows));\n");
            bw.write("mycols[order(data$flows)]<-xcols;\n");
            bw.write("V(iG)[as.vector(data$gene)]$colors <- mycols;\n");
            bw.write("V(iG)[as.vector(data$gene)]$diffs <- data$flows;\n");
            bw.write("V(iG)[as.vector(totalFlow$gene)]$totalFlows <- totalFlow$flows;\n");
            bw.write("V(iG)$degree <- igraph::degree(iG);\n");
            bw.write("neighS <- V(induced.subgraph(graph=iG,vids=unlist(neighborhood(graph=iG,order=1,nodes='s'))))$name;\n");
            bw.write("neighT <- V(induced.subgraph(graph=iG,vids=unlist(neighborhood(graph=iG,order=1,nodes='t'))))$name;\n");
            bw.write("V(iG)$props = rep(\"PROTEIN\", length(V(iG)$name));\n");
            bw.write("V(iG)[match(neighS, V(iG)$name)]$props = \"SOURCE\";\n");
            bw.write("V(iG)[match(neighT, V(iG)$name)]$props = \"TARGET\";\n");
            bw.write("iG2 <- delete.vertices(iG, c('s','t'));\n");
            bw.write("write.graph(iG2," + write_1 + ", format = 'gml');\n");
            bw.write("}");
            bw.write("#--------------------------------------------------------------------------\n");
            bw.close();
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
        return scriptName;
    }

    public String createBarplotScript(String dir, String name, String disease, double corThreshold, double ratioThreshold, String filename) {
        String scriptName = dir + filename + "_barplotScript.R";
        String file = "'" + name + ".txt'";
        String write_1 = "'" + dir + filename + "_keyEdges.pdf" + "'";
        String write_2 = "'" + dir + filename + "_keyEdges.txt" + "'";
        try {
            File f = new File(scriptName);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("library(gplots);\n");
            bw.write("library(ggplot2);\n");
            bw.write("library(grid); \n");
            bw.write("library(reshape); \n");
            bw.write("library(reshape2); \n");
            bw.write("library(plyr); \n");
            bw.write("library(RColorBrewer); \n");
            bw.write("library(igraph); \n");
            bw.write("library(Vennerable); \n");
            bw.write("flows <- read.table(" + file + ", sep='\t', header = TRUE); \n");
            bw.write("rownames(flows) <- as.vector(flows$edge); \n");
            bw.write("flows <- flows[,c(2, 3)]; \n");
            bw.write("flows <- flows[which(flows$" + disease + " > " + corThreshold + "),]; \n");
            bw.write("flows <- flows[which(flows$" + disease + " / flows$control > " + ratioThreshold + "),]; \n");
            bw.write("flows <- flows[order(flows$" + disease + ", decreasing=TRUE),]; \n");
            bw.write("pca <- prcomp(t(flows), center=TRUE, scale=FALSE); \n");
            bw.write("max <- 10; \n");
            bw.write("loadings <- pca$rotation; \n");
            bw.write("pc1 <- loadings[order(loadings[,1], decreasing=TRUE), 1]; \n");
            bw.write("pc2 <- loadings[order(loadings[,2], decreasing=TRUE), 2]; \n");
            bw.write("top.genes <- unique(c(names(pc1[1:max]), names(pc1[(length(pc1) - max):length(pc1)]), names(pc2[1:max]), names(pc2[(length(pc2) - max):length(pc2)]))); \n");
            bw.write("flows.m <- flows[top.genes,]; \n");
            bw.write("write.table(flows.m, file=" + write_2 + ", sep='\t', quote=FALSE); \n");
            bw.write("flows.m <- flows.m[order(flows.m$control, decreasing=TRUE),]; \n");
            bw.write("flows.m$edges = rownames(flows.m); \n");
            bw.write("flows.m <- melt(flows.m, id.var='edges'); \n");
            bw.write("flows.m$edges <- factor(flows.m$edges, levels=flows.m$edges); \n");
            bw.write("colls <- c('#BDC9E1', '#67A9CF', '#1C9099', '#016C59', '#0023a0', '#f9a635', 'red', 'black'); \n");
            bw.write("pdf(file=" + write_1 + ", width=5, height=3); \n");
            bw.write("figure <- ggplot(data=flows.m, aes(x=edges, y=value, group=variable, fill=variable))+ geom_bar(stat=\"identity\", width=.7, colour='black') + theme_bw() + guides(fill=guide_legend(ncol=2)) + theme(legend.position=\"top\",legend.key.size = unit(0.3, \"cm\"), legend.text=element_text(size=7)) + xlab(\"\") + ylab(\"Edge Flow\") + theme(axis.text.x = element_text(size=6, angle=45, hjust=1), axis.title.y = element_text(size = rel(1), angle = 90), axis.text.y = element_text(size=6, angle=00, hjust=1)) + scale_fill_manual('', values=c(colls[3], colls[6])); \n");
            bw.write("print(figure); \n");
            bw.write("dev.off(); \n");
            bw.write("#--------------------------------------------------------------------------\n");
            bw.close();
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
        try {
            System.out.println("Running Runtime.exec() to create barplot");
            Runtime.getRuntime().exec("R --slave --no-save CMD BATCH " + scriptName);
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
        return scriptName;
    }

    public String createScritpHeatmap_CCS_1(String dir, String filename, String state) {
        String scriptName = dir + filename + "_heatmapScript.R";
        String file1 = "'" + dir + filename + ".txt" + "'";
        String write = "'" + dir + filename + ".pdf" + "'";
        System.out.println("saving impact scores...");
        try {
            File f = new File(scriptName);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("library(gplots);\n");
            bw.write("library(ggplot2);\n");
            bw.write("library(grid); \n");
            bw.write("library(reshape); \n");
            bw.write("library(reshape2); \n");
            bw.write("library(plyr); \n");
            bw.write("library(RColorBrewer); \n");
            bw.write("library(igraph); \n");
            bw.write("library(Vennerable); \n");
            bw.write("file1 <- read.table(" + file1 + ", sep='\\t', header = TRUE); \n");
            bw.write("colnames(file1) <- c('genes','state'); \n");
            bw.write("file1$group <- '" + state + "'; \n");
            bw.write("matrix <- file1; \n");
            bw.write("print(matrix); \n");
            bw.write("matrix.m <- matrix; \n");
            bw.write("matrix.m$genes <- factor(matrix.m$genes, levels=matrix.m[order(matrix.m$state, decreasing=TRUE), 'genes']); \n");
            bw.write("w=8; \n");
            bw.write("h=2; \n");
            bw.write("pdf(file=" + write + ", width=w, height=h); \n");
            bw.write("figure <- ggplot(matrix.m, aes(group, genes)) + geom_tile(aes(fill = state), colour = 'black') + scale_fill_gradient2(name='IP',low='darkblue', mid='white', high='red', guide='colorbar') + theme_bw() + xlab('') + ylab('') + theme(legend.position='bottom', legend.direction='horizontal') + theme(axis.text.x = element_text(size=rel(0.75), angle=45, hjust=1), axis.text.y = element_text(size = rel(0.85), angle = 00)) + coord_flip(); \n");
            bw.write("print(figure); \n");
            bw.write("dev.off(); \n");
            bw.write("#--------------------------------------------------------------------------\n");
            bw.close();
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
        return scriptName;
    }

    public void createScritpHeatmap_CCS(String dir, String filename1, String filename2, String filename, String state1, String state2) {
        String scriptName = dir + filename + "_heatmapScript.R";
        String file1 = "'" + dir + filename1 + "'";
        String file2 = "'" + dir + filename2 + "'";
        String write = "'" + dir + filename + ".pdf" + "'";
        System.out.println("saving impact scores...");
        try {
            File f = new File(scriptName);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("library(gplots);\n");
            bw.write("library(ggplot2);\n");
            bw.write("library(grid); \n");
            bw.write("library(reshape); \n");
            bw.write("library(reshape2); \n");
            bw.write("library(plyr); \n");
            bw.write("library(RColorBrewer); \n");
            bw.write("library(igraph); \n");
            bw.write("library(Vennerable); \n");
            bw.write("file1 <- read.csv(" + file1 + ", sep='\t'); \n");
            bw.write("file2 <- read.csv(" + file2 + ", sep='\t'); \n");
            bw.write("colnames(file1) <- c('expression','state','CCS'); \n");
            bw.write("colnames(file2) <- c('expression','state','CCS'); \n");
            bw.write("file1$group <- '" + state1 + "'; \n");
            bw.write("file2$group <- '" + state2 + "'; \n");
            bw.write("matrix <- rbind(file1, file2); \n");
            bw.write("print(matrix); \n");
            bw.write("matrix.m <- matrix; \n");
            bw.write("matrix.m$state <- factor(matrix.m$state, levels=matrix.m[order(matrix.m$CCS, decreasing=TRUE), 'state']); \n");
            bw.write("w=15; \n");
            bw.write("h=2.2; \n");
            bw.write("pdf(file=" + write + ", width=w, height=h); \n");
            bw.write("figure <- ggplot(matrix.m, aes(group, state)) + geom_tile(aes(fill = CCS), colour = 'black') + scale_fill_gradient2(name='IP',low='darkblue', mid='white', high='red', guide='colorbar') + theme_bw() + xlab('') + ylab('') + theme(legend.position='bottom', legend.direction='horizontal') + theme(axis.text.x = element_text(size=rel(0.75), angle=45, hjust=1), axis.text.y = element_text(size = rel(0.85), angle = 00)) + coord_flip(); \n");
            bw.write("print(figure); \n");
            bw.write("dev.off(); \n");
            bw.write("#--------------------------------------------------------------------------\n");
            bw.close();
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
        try {
            Runtime.getRuntime().exec("R --slave --no-save CMD BATCH " + scriptName);
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
    }

    public void plotBarplot(String dir, String name, String disease, double corThreshold, double ratioThreshold, String filename) {
        String file = "'" + name + ".txt'";
        String write_1 = "'" + dir + filename + "_keyEdges.pdf" + "'";
        String write_2 = "'" + dir + filename + "_keyEdges.txt" + "'";
        System.out.println("saving key edges...");
        this.re.eval("flows <- read.table(" + file + ", sep='\t', header = TRUE)");
        this.re.eval("rownames(flows) <- as.vector(flows$edge)");
        this.re.eval("flows <- flows[,c(2, 3)]");
        this.re.eval("flows <- flows[which(flows$" + disease + " > " + corThreshold + "),]");
        this.re.eval("flows <- flows[which(flows$" + disease + " / flows$control > " + ratioThreshold + "),]");
        this.re.eval("flows <- flows[order(flows$" + disease + ", decreasing=TRUE),]");
        this.re.eval("pca <- prcomp(t(flows), center=TRUE, scale=FALSE)");
        this.re.eval("max <- 10");
        this.re.eval("loadings <- pca$rotation");
        this.re.eval("pc1 <- loadings[order(loadings[,1], decreasing=TRUE), 1]");
        this.re.eval("pc2 <- loadings[order(loadings[,2], decreasing=TRUE), 2]");
        this.re.eval("top.genes <- unique(c(names(pc1[1:max]), names(pc1[(length(pc1) - max):length(pc1)]), names(pc2[1:max]), names(pc2[(length(pc2) - max):length(pc2)])))");
        this.re.eval("flows.m <- flows[top.genes,]");
        this.re.eval("write.table(flows.m, file=" + write_2 + ", sep='\t', quote=FALSE)");
        this.re.eval("flows.m <- flows.m[order(flows.m$control, decreasing=TRUE),]");
        this.re.eval("flows.m$edges = rownames(flows.m)");
        this.re.eval("flows.m <- melt(flows.m, id.var='edges')");
        this.re.eval("flows.m$edges <- factor(flows.m$edges, levels=flows.m$edges)");
        this.re.eval("colls <- c('#BDC9E1', '#67A9CF', '#1C9099', '#016C59', '#0023a0', '#f9a635', 'red', 'black')");
        this.re.eval("pdf(file=" + write_1 + ", width=5, height=3);");
        this.re.eval("figure <- ggplot(data=flows.m, aes(x=edges, y=value, group=variable, fill=variable))+ geom_bar(stat=\"identity\", width=.7, colour='black') + theme_bw() + guides(fill=guide_legend(ncol=2)) + theme(legend.position=\"top\",legend.key.size = unit(0.3, \"cm\"), legend.text=element_text(size=7)) + xlab(\"\") + ylab(\"Edge Flow\") + theme(axis.text.x = element_text(size=6, angle=45, hjust=1), axis.title.y = element_text(size = rel(1), angle = 90), axis.text.y = element_text(size=6, angle=00, hjust=1)) + scale_fill_manual('', values=c(colls[3], colls[6]))");
        this.re.eval("print(figure)");
        this.re.eval("dev.off();");
    }

    public void plotHeatmap_CCS(String dir, String filename1, String filename2, String filename, String state1, String state2) {
        String file1 = "'" + dir + filename1 + "'";
        String file2 = "'" + dir + filename2 + "'";
        String write = "'" + dir + filename + ".pdf" + "'";
        System.out.println("saving impact scores...");
        this.re.eval("file1 <- read.csv(" + file1 + ", sep='\t')");
        this.re.eval("file2 <- read.csv(" + file2 + ", sep='\t')");
        this.re.eval("colnames(file1) <- c('expression','state','CCS')");
        this.re.eval("colnames(file2) <- c('expression','state','CCS')");
        this.re.eval("file1$group <- '" + state1 + "'");
        this.re.eval("file2$group <- '" + state2 + "'");
        this.re.eval("matrix <- rbind(file1, file2)");
        this.re.eval("print(matrix)");
        this.re.eval("matrix.m <- matrix");
        this.re.eval("matrix.m$state <- factor(matrix.m$state, levels=matrix.m[order(matrix.m$CCS, decreasing=TRUE), 'state'])");
        this.re.eval("w=15");
        this.re.eval("h=2.2");
        this.re.eval("pdf(file=" + write + ", width=w, height=h);");
        this.re.eval("figure <- ggplot(matrix.m, aes(group, state)) + geom_tile(aes(fill = CCS), colour = 'black') + scale_fill_gradient2(name='IP',low='darkblue', mid='white', high='red', guide='colorbar') + theme_bw() + xlab('') + ylab('') + theme(legend.position='bottom', legend.direction='horizontal') + theme(axis.text.x = element_text(size=rel(0.75), angle=45, hjust=1), axis.text.y = element_text(size = rel(0.85), angle = 00)) + coord_flip()");
        this.re.eval("print(figure)");
        this.re.eval("dev.off()");
    }

    public void plotHeatmap_CCS_2(String dir, String filename1, String filename2, String filename3, String filename, String state1, String state2, String state3) {
        String file1 = "'" + dir + filename1 + "'";
        String file2 = "'" + dir + filename2 + "'";
        String file3 = "'" + dir + filename3 + "'";
        String write = "'" + dir + filename + ".pdf" + "'";
        System.out.println("saving impact scores...");
        this.re.eval("file1 <- read.csv(" + file1 + ", sep='\t')");
        this.re.eval("file2 <- read.csv(" + file2 + ", sep='\t')");
        this.re.eval("file3 <- read.csv(" + file3 + ", sep='\t')");
        this.re.eval("colnames(file1) <- c('expression','state','CCS')");
        this.re.eval("colnames(file2) <- c('expression','state','CCS')");
        this.re.eval("colnames(file3) <- c('expression','state','CCS')");
        this.re.eval("file1$group <- '" + state1 + "'");
        this.re.eval("file2$group <- '" + state2 + "'");
        this.re.eval("file3$group <- '" + state3 + "'");
        this.re.eval("matrix <- rbind(file1, file2, file3)");
        this.re.eval("print(matrix)");
        this.re.eval("matrix.m <- matrix");
        this.re.eval("matrix.m$state <- factor(matrix.m$state, levels=matrix.m[order(matrix.m$CCS, decreasing=TRUE), 'state'])");
        this.re.eval("w=15");
        this.re.eval("h=2.5");
        this.re.eval("pdf(file=" + write + ", width=w, height=h);");
        this.re.eval("figure <- ggplot(matrix.m, aes(group, state)) + geom_tile(aes(fill = CCS), colour = 'black') + scale_fill_gradient2(name='IP', low='darkblue', mid='white', high='red', guide='colorbar') + theme_bw() + xlab('') + ylab('') + theme(legend.position='bottom', legend.direction='horizontal') + theme(axis.text.x = element_text(size=rel(0.75), angle=45, hjust=1), axis.text.y = element_text(size = rel(0.85), angle = 00)) + coord_flip()");
        this.re.eval("print(figure)");
        this.re.eval("dev.off()");
    }

    public void plotAdjMatrix(String dir, String filename, String gene) {
        String file = "'" + dir + filename + ".txt" + "'";
        String write = "'" + dir + filename + ".pdf" + "'";
        System.out.println("saving adjacency matrices...");
        this.re.eval("matrix <- read.csv(" + file + ", sep='\t')");
        this.re.eval("rownames(matrix) <- matrix$gene");
        this.re.eval("matrix <- matrix[, 2:dim(matrix)[2]]");
        this.re.eval("matrix[row(matrix) > col(matrix)] <- 0.5");
        this.re.eval("diag(matrix) <- 0.5");
        this.re.eval("matrix <- data.frame(gene=rownames(matrix), matrix)");
        this.re.eval("matrix.m <- melt(matrix, id.var='gene')");
        this.re.eval("matrix.m <- na.omit(matrix.m)");
        this.re.eval("matrix.m$gene <- factor(matrix.m$gene, levels=matrix.m$gene)");
        this.re.eval("matrix.m$variable <- factor(matrix.m$variable, levels=rev(levels(matrix.m$gene)))");
        this.re.eval("matrix.m <- ddply(matrix.m, .(variable), transform, rescale = value)");
        this.re.eval("w=dim(matrix)[1] / 2.5");
        this.re.eval("h=dim(matrix)[2] / 3");
        this.re.eval("pdf(file=" + write + ", width=w, height=h);");
        this.re.eval("figure <- ggplot(matrix.m, aes(gene, variable)) + geom_tile(aes(fill = value), colour = 'black') + scale_fill_gradient(low = 'white', high = 'red') + theme_bw() + xlab('') + ylab('') + theme(panel.grid=element_blank(), panel.border=element_blank(), legend.position='none', axis.text.x = element_text(size=rel(1), angle=45, hjust=1),axis.title.y = element_text(size = rel(0.3), angle = 90)) + ggtitle('" + gene + "'" + ")");
        this.re.eval("print(figure)");
        this.re.eval("dev.off()");
    }

    public void plotJaccardMatrix(String filename) {
        String file = "'" + filename + ".txt" + "'";
        String write = "'" + filename + ".pdf" + "'";
        System.out.println("saving Jaccard index heatmap...");
        this.re.eval("sim <- read.csv(" + file + ", sep='\t')");
        this.re.eval("names <- as.vector(sim$X);");
        this.re.eval("sim <- sim[,2:dim(sim)[2]]");
        this.re.eval("rownames(sim) <- names;");
        this.re.eval("hmcols<- colorRampPalette(c(\"black\", \"yellow\"))");
        this.re.eval("pdf(file=" + write + ", width=5, height=5);");
        this.re.eval("heatmap.2(as.matrix(t(sim)), col=hmcols,trace=\"none\", density.info=\"none\", scale=\"none\",margin=c(15,15), key=TRUE, Rowv=T, Colv=T,srtCol=60, dendrogram=\"none\", cexCol=0.55, cexRow=0.55, symm=T,  sepcolor='black')");
        this.re.eval("dev.off()");
    }

    public static void addLibraryPath(String path) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        String oldPath = System.getProperty("java.library.path");
        if (oldPath.length() > 0) {
            path = path + ":" + oldPath;
        }
        System.setProperty("java.library.path", path);
        Field sysPathsField = ClassLoader.class.getDeclaredField("sys_paths");
        sysPathsField.setAccessible(true);
        sysPathsField.set(null, null);
    }
}

