/*
 * Decompiled with CFR 0.152.
 */
package netdecoder;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class OntologyUtils {
    private BufferedReader in;
    private String buffer;
    private Map<String, Term> id2term = new LinkedHashMap<String, Term>();

    public OntologyUtils(String file) throws IOException {
        this.parse(file);
    }

    public static void main(String[] args) throws IOException {
        String file = "/home/edroaldo/Documents/Projects/Yeast/gene_ontology_ext_FULL.obo";
        OntologyUtils utils = new OntologyUtils(file);
        System.out.println(utils.id2term.size());
        LinkedHashSet<String> leafs = new LinkedHashSet<String>();
        for (String i : utils.id2term.keySet()) {
            Term term = utils.id2term.get(i);
            if (!term.getNamespace().equals("biological_process")) continue;
            System.out.println(term.getId());
            System.out.println("Parents: " + term.is_a);
            System.out.println("Children: " + term.children);
            utils.dfsLeafs(term.getId(), leafs);
        }
        System.out.println("----------------Searching---------------");
        System.out.println("Leafs");
        System.out.println(leafs);
        System.out.println(leafs.size());
    }

    public Set<String> getDepth(String s, int depth, boolean parents) {
        LinkedHashSet<String> depthParents = new LinkedHashSet<String>();
        LinkedHashSet<String> depthChildren = new LinkedHashSet<String>();
        if (parents) {
            this.dfsParents(s, depth, depthParents);
            return depthParents;
        }
        this.dfsChildren(s, depth, depthChildren);
        return depthChildren;
    }

    public Set<String> getDepth(String s, int depth) {
        LinkedHashSet<String> depthGOs = new LinkedHashSet<String>();
        this.dfsParents(s, depth, depthGOs);
        this.dfsChildren(s, depth, depthGOs);
        return depthGOs;
    }

    public void dfsParents(String s, int depth, Set<String> depthParents) {
        if (depth > 0) {
            for (String w : this.getTerm((String)s, (boolean)false).is_a) {
                depthParents.add(w);
                this.dfsParents(w, depth - 1, depthParents);
            }
        }
    }

    public void dfsChildren(String s, int depth, Set<String> depthChildren) {
        if (depth > 0) {
            for (String w : this.getTerm((String)s, (boolean)false).children) {
                depthChildren.add(w);
                this.dfsParents(w, depth - 1, depthChildren);
            }
        }
    }

    public Set<String> dfsLeafs(String s, Set<String> leafs) {
        if (this.getTerm(s, false).getNamespace().equals("biological_process") && this.getTerm((String)s, (boolean)false).children.isEmpty()) {
            leafs.add(s);
        } else {
            for (String w : this.getTerm((String)s, (boolean)false).children) {
                this.dfsLeafs(w, leafs);
            }
        }
        return leafs;
    }

    public Map<String, Term> getGOHierarchy() throws IOException {
        return this.id2term;
    }

    private Term getTerm(String id, boolean create) {
        Term term = this.id2term.get(id);
        if (term == null && create) {
            term = new Term();
            term.setId(id);
            term.setName(id);
            term.setNamespace(id);
            term.setDef(id);
            this.id2term.put(id, term);
        }
        return term;
    }

    private String nocomment(String s) {
        int remove = s.indexOf("!");
        if (remove != -1) {
            s = s.substring(0, remove);
        }
        return s.trim();
    }

    private String next() throws IOException {
        if (this.buffer != null) {
            String s = this.buffer;
            this.buffer = null;
            return s;
        }
        return this.in.readLine();
    }

    private void parse(String file) throws IOException {
        String line;
        FileInputStream inStream = new FileInputStream(file);
        this.in = new BufferedReader(new InputStreamReader(inStream));
        while ((line = this.next()) != null) {
            if (!line.equals("[Term]")) continue;
            this.parseTerm();
        }
        this.in.close();
    }

    private void parseTerm() throws IOException {
        String line;
        Term term = null;
        while ((line = this.next()) != null) {
            if (line.startsWith("[")) {
                this.buffer = line;
                break;
            }
            int colon = line.indexOf(":");
            if (colon == -1) continue;
            if (line.startsWith("id:") && term == null) {
                String GOId = line.substring(colon + 1).trim();
                term = this.getTerm(GOId, true);
                continue;
            }
            if (term == null) continue;
            if (line.startsWith("name:")) {
                String name = this.nocomment(line.substring(colon + 1));
                term.setName(name);
                continue;
            }
            if (line.startsWith("namespace:")) {
                String namespace = this.nocomment(line.substring(colon + 1));
                term.setNamespace(namespace);
                continue;
            }
            if (line.startsWith("def:")) {
                String def = this.nocomment(line.substring(colon + 1));
                term.setDef(def);
                continue;
            }
            if (!line.startsWith("is_a:")) continue;
            String parentGO = this.nocomment(line.substring(colon + 1));
            term.is_a.add(parentGO);
            Term parent = this.getTerm(parentGO, true);
            parent.children.add(term.getId());
        }
    }

    public class Term {
        private String id;
        private String name;
        private String namespace;
        private String def;
        Set<String> children = new LinkedHashSet<String>();
        Set<String> is_a = new LinkedHashSet<String>();

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public String getDef() {
            return this.def;
        }

        public void setDef(String def) {
            this.def = def;
        }
    }
}

