/*
 * Decompiled with CFR 0.152.
 */
package netdecoder;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class InputOutput {
    private List<String> proteinsA;
    private List<String> proteinsB;
    private List<String> miscores;
    private List<Double> correlations;
    private List<Double> signCors;
    private String file;
    private final int PROTEINA = 0;
    private final int PROTEINB = 1;
    private final int COR = 2;
    private final int SIGNCOR = 3;

    public InputOutput() {
        this.proteinsA = new ArrayList<String>();
        this.proteinsB = new ArrayList<String>();
        this.miscores = new ArrayList<String>();
        this.correlations = new ArrayList<Double>();
        this.signCors = new ArrayList<Double>();
    }

    public InputOutput(String file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getColumnFromMITABFaster(String file) throws IOException {
        try (BufferedReader in = null;){
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                String[] columns = line.split("\t");
                this.proteinsA.add(columns[0]);
                this.proteinsB.add(columns[1]);
                this.correlations.add(Double.valueOf(columns[2]));
                this.signCors.add(Double.valueOf(columns[3]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getProteinsMITABFaster(String file) throws IOException {
        BufferedReader in = null;
        this.proteinsA.clear();
        this.proteinsB.clear();
        this.miscores.clear();
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                String[] columns = line.split("\t");
                this.proteinsA.add(columns[0]);
                this.proteinsB.add(columns[1]);
                this.miscores.add(columns[2]);
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> mapUniprot2txt(String file) throws IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try (BufferedReader in = null;){
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                String[] columns = line.split("\t");
                String uniprot = columns[1];
                String id = columns[2];
                map.put(uniprot, id);
            }
            LinkedHashMap<String, String> linkedHashMap = map;
            return linkedHashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> mapGOtxt(String file) throws IOException {
        LinkedHashMap<String, List<String>> go = new LinkedHashMap<String, List<String>>();
        try (BufferedReader in = null;){
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                String[] columns = line.split("\t");
                String uniprot = columns[2];
                String goID = columns[4];
                if (!go.containsKey(uniprot)) {
                    ArrayList<String> gos = new ArrayList<String>();
                    gos.add(goID);
                    go.put(uniprot, gos);
                    continue;
                }
                ((List)go.get(uniprot)).add(goID);
            }
            LinkedHashMap<String, List<String>> linkedHashMap = go;
            return linkedHashMap;
        }
    }

    public Map<String, Map<String, List<String>>> combineIdGO2(Map<String, List<String>> sgd, Map<String, List<String>> go) {
        LinkedHashMap<String, Map<String, List<String>>> map = new LinkedHashMap<String, Map<String, List<String>>>();
        for (String s : sgd.keySet()) {
            LinkedHashMap<String, List<String>> n = new LinkedHashMap<String, List<String>>();
            String idSGD = sgd.get(s).get(0);
            if (!go.containsKey(idSGD)) continue;
            List<String> l = go.get(idSGD);
            n.put(idSGD, l);
            map.put(s, n);
        }
        return map;
    }

    public Map<String, List<String>> combineIdGO(Map<String, List<String>> sgd, Map<String, List<String>> go) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        for (String s : sgd.keySet()) {
            String idSGD = sgd.get(s).get(0);
            if (!go.containsKey(idSGD)) continue;
            List<String> l = go.get(idSGD);
            map.put(s, l);
        }
        return map;
    }

    public List<String> getProteinsA() {
        return this.proteinsA;
    }

    public void setProteinsA(List<String> proteinsA) {
        this.proteinsA = proteinsA;
    }

    public List<String> getProteinsB() {
        return this.proteinsB;
    }

    public void setProteinsB(List<String> proteinsB) {
        this.proteinsB = proteinsB;
    }

    public List<String> getMiscores() {
        return this.miscores;
    }

    public void setMiscores(List<String> miscores) {
        this.miscores = miscores;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public List<Double> getCorrelations() {
        return this.correlations;
    }

    public void setCorrelations(List<Double> correlations) {
        this.correlations = correlations;
    }

    public List<Double> getSignCors() {
        return this.signCors;
    }

    public void setSignCors(List<Double> signCors) {
        this.signCors = signCors;
    }
}

