/*
 * Decompiled with CFR 0.152.
 */
package netdecoder;

import java.io.Serializable;
import netdecoder.Node;

public class Edge
implements Serializable,
Comparable<Edge> {
    private Node from;
    private Node to;
    private Edge reverse;
    private double capacity;
    private double score;
    private double signScore;
    private double flow;
    private double cost;
    private int path;
    private double difference;

    public Edge(Node from, Node to) {
        this.from = from;
        this.to = to;
        this.flow = 0.0;
        this.signScore = 0.0;
        this.path = -1;
        this.difference = 0.0;
    }

    public Edge(Node from, Node to, double capacity) {
        this.from = from;
        this.to = to;
        this.capacity = capacity;
        this.flow = 0.0;
        this.signScore = 0.0;
        this.path = -1;
        this.difference = 0.0;
    }

    public Edge(Node from, Node to, double capacity, double cost) {
        this.from = from;
        this.to = to;
        this.capacity = capacity;
        this.flow = 0.0;
        this.signScore = 0.0;
        this.cost = cost;
        this.path = -1;
        this.difference = 0.0;
    }

    public String toString() {
        String[] s1 = this.from.getName().split("\\/");
        String[] s2 = this.to.getName().split("\\/");
        return s1[0] + "->" + s2[0];
    }

    public double residualCapacityTo(Node node) {
        if (node.getName().equals(this.from.getName())) {
            return this.flow;
        }
        if (node.getName().equals(this.to.getName())) {
            return this.capacity - this.flow;
        }
        throw new IllegalArgumentException("Illegal node");
    }

    public void addResidualFlowTo(Node node, double delta) {
        if (node.getName().equals(this.from.getName())) {
            this.flow -= delta;
        } else if (node.getName().equals(this.to.getName())) {
            this.flow += delta;
        }
    }

    public boolean isFrom(Node from) {
        return this.from.equals(from.getName());
    }

    public int hashCode() {
        return (this.from.getName() + this.to.getName()).hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Edge) {
            Edge toCompare = (Edge)o;
            return this.from.equals(toCompare.from) && this.to.equals(toCompare.to);
        }
        return false;
    }

    public Node getOther(Node node) {
        if (node.getName().equals(this.from.getName())) {
            return this.to;
        }
        if (node.getName().equals(this.to.getName())) {
            return this.from;
        }
        throw new IllegalArgumentException("Illegal endpoint");
    }

    public Node getFrom() {
        return this.from;
    }

    public void setFrom(Node from) {
        this.from = from;
    }

    public Node getTo() {
        return this.to;
    }

    public void setTo(Node to) {
        this.to = to;
    }

    public double getCapacity() {
        return this.capacity;
    }

    public void setCapacity(double capacity) {
        this.capacity = capacity;
    }

    public double getMiscore() {
        return this.score;
    }

    public void setMiscore(double miscore) {
        this.score = miscore;
    }

    public double getFlow() {
        return this.flow;
    }

    public void setFlow(double flow) {
        this.flow = flow;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    @Override
    public int compareTo(Edge edge) {
        if (this.cost < edge.getCost()) {
            return -1;
        }
        if (this.cost > edge.getCost()) {
            return 1;
        }
        return 0;
    }

    public Edge getReverse() {
        return this.reverse;
    }

    public void setReverse(Edge reverse) {
        this.reverse = reverse;
    }

    public int getPath() {
        return this.path;
    }

    public void setPath(int path) {
        this.path = path;
    }

    public double getDifference() {
        return this.difference;
    }

    public void setDifference(double difference) {
        this.difference = difference;
    }

    public double getSignScore() {
        return this.signScore;
    }

    public void setSignScore(double signScore) {
        this.signScore = signScore;
    }
}

