/*
 * Decompiled with CFR 0.152.
 */
package netdecoder;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import netdecoder.Edge;

public class Path {
    List<Edge> path = new ArrayList<Edge>();
    double cost = 0.0;
    double flow = 0.0;

    public Path(List<Edge> path) {
        this.path = path;
        this.cost = this.getCost();
        this.flow = this.getFlow();
    }

    public List<Edge> getPath() {
        return this.path;
    }

    public double getCost() {
        double cost = 0.0;
        for (Edge e : this.path) {
            cost += e.getCost();
        }
        return cost;
    }

    public String toString() {
        String p = "";
        int i = 0;
        for (Edge e : this.path) {
            p = i < this.path.size() - 1 ? p + e.getFrom().getName() + "->" : p + e;
            ++i;
        }
        return p;
    }

    public Path reversePath() {
        Stack<Edge> reverseAux = new Stack<Edge>();
        ArrayList<Edge> reversePath = new ArrayList<Edge>();
        for (Edge e : this.path) {
            reverseAux.push(e);
        }
        while (!reverseAux.isEmpty()) {
            reversePath.add((Edge)reverseAux.pop());
        }
        return new Path(reversePath);
    }

    public double getFlow() {
        double flow = 0.0;
        for (Edge e : this.path) {
            if (e.getFrom().getName().equals("s") || e.getTo().getName().equals("t")) continue;
            flow += e.getFlow();
        }
        return flow;
    }

    public boolean equals(Object o) {
        if (o instanceof Path) {
            Path toCompare = (Path)o;
            return this.path.equals(toCompare.path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

