/*
 * Decompiled with CFR 0.152.
 */
package netdecoder;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import netdecoder.Edge;

public class Node
implements Serializable {
    private String name;
    private String sgd;
    private String symbol;
    private int id;
    static int nextId = 0;
    private boolean visited;
    private ArrayList<Edge> edges;
    private ArrayList<String> geneOntology;
    private ArrayList<String> currentGOs;
    private Set<String> outflowGOs;
    private ArrayList<String> functionalContext;
    private Map<String, Set<String>> outflowGOmap;
    private Set<String> functionalCategory;
    private double expression;

    public Node(String name, int id) {
        this.setName(name);
        this.setId(id);
    }

    public Node(String name) {
        this.name = name;
        this.edges = new ArrayList();
        this.geneOntology = new ArrayList();
        this.currentGOs = new ArrayList();
        this.outflowGOs = new LinkedHashSet<String>();
        this.outflowGOmap = new LinkedHashMap<String, Set<String>>();
        this.functionalContext = new ArrayList();
        this.functionalCategory = new LinkedHashSet<String>();
        this.visited = false;
        this.expression = 0.0;
    }

    public Node copyNode() {
        Node node = new Node(this.getName());
        node.name = this.getName();
        node.symbol = this.getSymbol();
        node.geneOntology = new ArrayList();
        node.currentGOs = new ArrayList();
        node.outflowGOs = new LinkedHashSet<String>();
        node.outflowGOmap = new LinkedHashMap<String, Set<String>>();
        node.functionalContext = new ArrayList();
        node.functionalCategory = new LinkedHashSet<String>();
        node.visited = false;
        node.expression = 0.0;
        return node;
    }

    public String toString() {
        return this.getName();
    }

    public int degree() {
        return this.getEdges().size() / 2;
    }

    public Set<String> getOutflowGOs() {
        return this.outflowGOs;
    }

    public void setOutflowGOs(Set<String> outflowsGO) {
        this.outflowGOs = outflowsGO;
    }

    public Iterator<Edge> edges() {
        return this.edges.iterator();
    }

    public void addEdge(Edge edge) {
        this.edges.add(edge);
    }

    public List<Node> getFlowNeighbors(Node previous) {
        ArrayList<Node> neighFlow = new ArrayList<Node>();
        for (Edge e : this.getEdges()) {
            Node u = e.getOther(this);
            if (u.getName().equals(previous.getName()) || e.getFlow() == 0.0 || neighFlow.contains(u)) continue;
            neighFlow.add(u);
        }
        return neighFlow;
    }

    public double getTotalFlow() {
        double flow = 0.0;
        for (Edge e : this.getEdges()) {
            flow += e.getFlow();
        }
        return flow;
    }

    public double getOutflow() {
        double flow = 0.0;
        for (Edge e : this.getEdges()) {
            if (!e.getFrom().getName().equals(this.getName())) continue;
            System.out.println("Edge: " + e + " Flow: " + e.getFlow());
            flow += e.getFlow();
        }
        return flow;
    }

    public Map<String, Double> getTopOutFlow() {
        LinkedHashMap<String, Double> outflows = new LinkedHashMap<String, Double>();
        for (Edge e : this.getEdges()) {
            if (!e.getFrom().getName().equals(this.getName())) continue;
            outflows.put(e.getTo().getName(), e.getFlow());
        }
        return outflows;
    }

    public double getInFlow() {
        double flow = 0.0;
        for (Edge e : this.getEdges()) {
            if (!e.getTo().getName().equals(this.getName())) continue;
            System.out.println("Edge: " + e + " Flow: " + e.getFlow());
            flow += e.getFlow();
        }
        return flow;
    }

    public Set<Node> getNeighbors() {
        LinkedHashSet<Node> neighbors = new LinkedHashSet<Node>();
        for (Edge e : this.getEdges()) {
            neighbors.add(e.getOther(this));
        }
        return neighbors;
    }

    public Set<Node> getNeighbors(double confidence) {
        LinkedHashSet<Node> neighbors = new LinkedHashSet<Node>();
        for (Edge e : this.getEdges()) {
            if (!(e.getCapacity() > confidence)) continue;
            neighbors.add(e.getOther(this));
        }
        return neighbors;
    }

    public Set<String> getNeighborsBasedOnFlow(double flow) {
        LinkedHashSet<String> neighbors = new LinkedHashSet<String>();
        for (Edge e : this.getEdges()) {
            if (!(e.getFlow() > flow)) continue;
            neighbors.add(e.getOther(this).getName());
        }
        return neighbors;
    }

    public Set<String> getGOContext(Map<String, Node> network, double confidence) {
        LinkedHashSet<String> goContext = new LinkedHashSet<String>();
        Set<Node> neighbors = this.getNeighbors(confidence);
        for (Node n : neighbors) {
            ArrayList<String> gos = network.get(n.getName()).getGeneOntology();
            if (gos.isEmpty()) continue;
            for (String g : gos) {
                goContext.add(g);
            }
        }
        return goContext;
    }

    public boolean equals(Object o) {
        if (o instanceof Node) {
            Node toCompare = (Node)o;
            return this.name.equals(toCompare.name);
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isVisited() {
        return this.visited;
    }

    public void setVisited(boolean visited) {
        this.visited = visited;
    }

    public ArrayList<Edge> getEdges() {
        return this.edges;
    }

    public void setEdges(ArrayList<Edge> edges) {
        this.edges = edges;
    }

    public String getSgd() {
        return this.sgd;
    }

    public void setSgd(String sgd) {
        this.sgd = sgd;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public ArrayList<String> getGeneOntology() {
        return this.geneOntology;
    }

    public void setGeneOntology(ArrayList<String> geneOntology) {
        this.geneOntology = geneOntology;
    }

    public ArrayList<String> getCurrentGOs() {
        return this.currentGOs;
    }

    public void setCurrentGOs(ArrayList<String> currentGOs) {
        this.currentGOs = currentGOs;
    }

    public ArrayList<String> getFunctionalContext() {
        return this.functionalContext;
    }

    public void setFunctionalContext(ArrayList<String> functionalContext) {
        this.functionalContext = functionalContext;
    }

    public Map<String, Set<String>> getOutflowGOmap() {
        return this.outflowGOmap;
    }

    public void setOutflowGOmap(Map<String, Set<String>> outflowGOmap) {
        this.outflowGOmap = outflowGOmap;
    }

    public Set<String> getFunctionalCategory() {
        return this.functionalCategory;
    }

    public void setFunctionalCategory(Set<String> functionalCategory) {
        this.functionalCategory = functionalCategory;
    }

    public double getExpression() {
        return this.expression;
    }

    public void setExpression(double expression) {
        this.expression = expression;
    }
}

