/*
 * Decompiled with CFR 0.152.
 */
package netdecoder;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import netdecoder.Edge;
import netdecoder.IndexMinPQ;
import netdecoder.InputOutput;
import netdecoder.Node;
import netdecoder.NodeInfo;
import netdecoder.OntologyUtils;
import netdecoder.Queue;

public class NetworkFlow
implements Serializable {
    private Map<String, Integer> symbolTable;
    private final List<NodeInfo> nodes;
    private Map<String, NodeInfo> nodesPath = new LinkedHashMap<String, NodeInfo>();
    private Map<String, Edge> edgeTo;
    private Map<String, Double> distTo;
    private IndexMinPQ<Double> ipq;
    private Node source;
    private Node target;
    private double value;
    private int E;
    private int nodeId;
    private PriorityQueue<Edge> pq;
    private Queue<Edge> mst;
    private double cost;
    private String[] keys;
    Set<String> enrichment = new LinkedHashSet<String>();
    LinkedHashSet<Edge> predicted = new LinkedHashSet();
    int pathNum = 1;
    Map<Integer, List<Edge>> highScoreProteins = new LinkedHashMap<Integer, List<Edge>>();

    public NetworkFlow() {
        this.pq = new PriorityQueue();
        this.nodes = new ArrayList<NodeInfo>();
        this.value = 0.0;
        this.E = 0;
        this.nodeId = 1;
    }

    public NetworkFlow(Node source, Node target) {
        this.source = source;
        this.target = target;
        this.nodes = null;
    }

    public static void main(String[] args) throws IOException {
    }

    public void saveAllPathsGO(Map<String, Node> network, Map<Integer, List<Edge>> paths, OntologyUtils utils) throws IOException {
        for (Integer i : paths.keySet()) {
            LinkedHashSet<Edge> path = new LinkedHashSet<Edge>((Collection)paths.get(i));
            List<String> goPath = this.getGOfromPath(network, path);
            String filename = "Path_" + i;
            this.savePathGO(goPath, path, utils, filename);
        }
    }

    public void saveTotalFlowByCategory(Map<String, Node> network, String comparison, List<String> category, String head, String file) throws IOException {
        File f = new File(file);
        if (!f.exists()) {
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("comparison\t" + head + "\t" + "netflow");
        bw.newLine();
        for (String n : category) {
            Node n1 = network.get(n);
            bw.write(comparison + "\t" + n1.getSymbol() + "\t" + n1.getTotalFlow());
            bw.newLine();
        }
        bw.close();
    }

    public void saveTotalFlow(Map<String, Node> network, String head, String file) throws IOException {
        File f = new File(file);
        if (!f.exists()) {
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(head + "\t" + "netflow");
        bw.newLine();
        for (String n : network.keySet()) {
            Node n1 = network.get(n);
            bw.write(n1.getSymbol() + "\t" + n1.getTotalFlow());
            bw.newLine();
        }
        bw.close();
    }

    public static void saveGOscoresW(Map<String, Double> GOscores, String condition, OntologyUtils utils, String file) throws IOException {
        File f = new File(file);
        if (!f.exists()) {
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("condition\tgoid\tgoname\tscore");
        bw.newLine();
        Map<String, OntologyUtils.Term> gos = utils.getGOHierarchy();
        for (String g : GOscores.keySet()) {
            OntologyUtils.Term term = gos.get(g);
            bw.write(condition + "\t" + term.getId() + "\t" + term.getName() + "\t" + GOscores.get(g));
            bw.newLine();
        }
        bw.close();
    }

    public static void saveGOscores(Map<String, Integer> GOscores, String condition, OntologyUtils utils, String file) throws IOException {
        File f = new File(file);
        if (!f.exists()) {
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("condition\tgoid\tgoname\tscore");
        bw.newLine();
        Map<String, OntologyUtils.Term> gos = utils.getGOHierarchy();
        for (String g : GOscores.keySet()) {
            OntologyUtils.Term term = gos.get(g);
            bw.write(condition + "\t" + term.getId() + "\t" + term.getName() + "\t" + GOscores.get(g));
            bw.newLine();
        }
        bw.close();
    }

    public void savePathGO(List<String> go, Set<Edge> path, OntologyUtils utils, String filename) throws IOException {
        String file = "/home/edroaldo/Documents/Projects/CRISP/cas9Network/Short-Clean-data-log2/Clean/Cas9-20317/DGE/Fold-Change-P-value/";
        File f = new File(file = file + filename);
        if (!f.exists()) {
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        for (Edge e : path) {
            bw.write(e + "\t");
        }
        bw.write("\n");
        for (String s : go) {
            OntologyUtils.Term term = utils.getGOHierarchy().get(s);
            bw.write(term.getId() + ": " + term.getName() + "\n");
        }
        bw.close();
    }

    public Map<Integer, List<Edge>> getWTPaths(Map<Integer, List<Edge>> paths, int numPaths) {
        LinkedHashMap<Integer, List<Edge>> wtPaths = new LinkedHashMap<Integer, List<Edge>>();
        LinkedHashMap<Integer, Double> lowCost = new LinkedHashMap<Integer, Double>();
        for (Integer p : paths.keySet()) {
            double cost = 0.0;
            for (Edge e : paths.get(p)) {
                cost += e.getCost();
            }
            lowCost.put(p, cost);
        }
        Map sorted = NetworkFlow.sortByValues(lowCost);
        int num = 0;
        if (numPaths == -1) {
            for (Integer s : sorted.keySet()) {
                wtPaths.put(s, paths.get(s));
            }
        } else {
            for (Integer s : sorted.keySet()) {
                if (num++ != numPaths) {
                    wtPaths.put(s, paths.get(s));
                    continue;
                }
                break;
            }
        }
        System.out.println("------------------");
        for (Integer s : wtPaths.keySet()) {
            System.out.println(s + " " + wtPaths.get(s));
        }
        return wtPaths;
    }

    public void showGO(List<String> go, OntologyUtils utils) throws IOException {
        for (String s : go) {
            OntologyUtils.Term term = utils.getGOHierarchy().get(s);
            System.out.println(term.getId() + ": " + term.getName());
        }
    }

    public List<String> getGOfromPath(Map<String, Node> network, Set<Edge> path) {
        LinkedHashSet<String> go = new LinkedHashSet<String>();
        for (Edge e : path) {
            Node from = network.get(e.getFrom().getName());
            Node to = network.get(e.getTo().getName());
            System.out.println(to.getSymbol() + " " + to.getCurrentGOs());
            go.addAll(from.getCurrentGOs());
        }
        return new ArrayList<String>(go);
    }

    public List<String> getGOfromPaths(Map<String, Node> network, Map<Integer, List<Edge>> paths) {
        LinkedHashSet<String> go = new LinkedHashSet<String>();
        for (Integer i : paths.keySet()) {
            System.out.println(i + " " + paths.get(i));
            for (Edge e : paths.get(i)) {
                Node from = network.get(e.getFrom().getName());
                go.addAll(from.getGeneOntology());
            }
        }
        return new ArrayList<String>(go);
    }

    public Map<Integer, List<Edge>> mergePaths(Map<Integer, List<Edge>> topSubnet1, Map<Integer, List<Edge>> topSubnet2) {
        LinkedHashMap<Integer, List<Edge>> combinedPaths = new LinkedHashMap<Integer, List<Edge>>();
        int n = 0;
        for (Integer i : topSubnet1.keySet()) {
            for (Integer j : topSubnet2.keySet()) {
                ArrayList<Edge> top1 = new ArrayList<Edge>((Collection)topSubnet1.get(i));
                List<Edge> top2 = this.reversePath(topSubnet2.get(j));
                top1.addAll(top2);
                combinedPaths.put(n, top1);
                ++n;
            }
        }
        System.out.println("----------combined paths-----------");
        for (Integer k : combinedPaths.keySet()) {
            double cost = 0.0;
            for (Edge e : (List)combinedPaths.get(k)) {
                cost += e.getCost();
            }
            System.out.println(k + ": " + combinedPaths.get(k) + " " + cost);
        }
        return combinedPaths;
    }

    public Map<String, Node> buildSubnetFromPaths2(Collection<List<Edge>> paths) {
        LinkedHashMap<String, Node> subnet = new LinkedHashMap<String, Node>();
        for (List<Edge> path : paths) {
            for (int i = 0; i < path.size(); ++i) {
                Edge auxE = path.get(i);
                Node from = new Node(auxE.getFrom().getName());
                from.setSymbol(auxE.getFrom().getSymbol());
                from.setCurrentGOs(auxE.getFrom().getCurrentGOs());
                from.setGeneOntology(auxE.getFrom().getGeneOntology());
                Node to = new Node(auxE.getTo().getName());
                to.setSymbol(auxE.getTo().getSymbol());
                to.setCurrentGOs(auxE.getTo().getCurrentGOs());
                to.setGeneOntology(auxE.getTo().getGeneOntology());
                if (!this.hasNode(subnet, from)) {
                    this.addNode(subnet, from);
                }
                if (!this.hasNode(subnet, to)) {
                    this.addNode(subnet, to);
                }
                Edge e = new Edge(from, to);
                e.setCapacity(auxE.getCapacity());
                e.setCost(auxE.getCost());
                e.setFlow(auxE.getFlow());
                if (!((Node)subnet.get(from.getName())).getEdges().contains(e)) {
                    ((Node)subnet.get(from.getName())).addEdge(e);
                }
                if (((Node)subnet.get(to.getName())).getEdges().contains(e)) continue;
                ((Node)subnet.get(to.getName())).addEdge(e);
            }
        }
        System.out.println("------------subnet from paths----------");
        System.out.println(subnet.size());
        return subnet;
    }

    public Map<String, Node> buildSubnetFromPaths(Map<Integer, List<Edge>> paths) {
        LinkedHashMap<String, Node> subnet = new LinkedHashMap<String, Node>();
        for (Integer k : paths.keySet()) {
            ArrayList path = new ArrayList(paths.get(k));
            for (int i = 0; i < path.size(); ++i) {
                Edge auxE = (Edge)path.get(i);
                Node from = new Node(auxE.getFrom().getName());
                from.setSymbol(auxE.getFrom().getSymbol());
                from.setCurrentGOs(auxE.getFrom().getCurrentGOs());
                from.setGeneOntology(auxE.getFrom().getGeneOntology());
                Node to = new Node(auxE.getTo().getName());
                to.setSymbol(auxE.getTo().getSymbol());
                to.setCurrentGOs(auxE.getTo().getCurrentGOs());
                to.setGeneOntology(auxE.getTo().getGeneOntology());
                if (!this.hasNode(subnet, from)) {
                    this.addNode(subnet, from);
                }
                if (!this.hasNode(subnet, to)) {
                    this.addNode(subnet, to);
                }
                Edge e = new Edge(from, to);
                e.setCapacity(auxE.getCapacity());
                e.setCost(auxE.getCost());
                e.setFlow(auxE.getFlow());
                if (!((Node)subnet.get(from.getName())).getEdges().contains(e)) {
                    ((Node)subnet.get(from.getName())).addEdge(e);
                }
                if (((Node)subnet.get(to.getName())).getEdges().contains(e)) continue;
                ((Node)subnet.get(to.getName())).addEdge(e);
            }
        }
        System.out.println("------------subnet from paths----------");
        System.out.println(subnet.size());
        return subnet;
    }

    public List<Edge> reversePath(List<Edge> path) {
        Stack<Edge> reverseAux = new Stack<Edge>();
        ArrayList<Edge> reversePath = new ArrayList<Edge>();
        for (Edge e : path) {
            if (e.getFrom().getName().equals("s")) continue;
            reverseAux.push(e);
        }
        while (!reverseAux.isEmpty()) {
            reversePath.add((Edge)reverseAux.pop());
        }
        return reversePath;
    }

    public Map<Integer, Map<String, Edge>> combineSubnets(Map<Integer, Map<String, Edge>> pathsSub1, Map<Integer, Map<String, Edge>> pathsSub2) {
        LinkedHashMap<Integer, Map<String, Edge>> newMap = new LinkedHashMap<Integer, Map<String, Edge>>();
        int k = 0;
        int i = 0;
        for (int j = 0; i < pathsSub1.size() && j < pathsSub2.size(); ++i, ++j) {
            newMap.put(k++, pathsSub1.get(i));
            newMap.put(k++, pathsSub2.get(j));
        }
        return newMap;
    }

    public Map<Integer, List<Edge>> lowCostPaths(Map<Integer, Map<String, Edge>> paths, Map<String, Node> network, int numPaths) {
        LinkedHashMap<Integer, Double> lowCost = new LinkedHashMap<Integer, Double>();
        LinkedHashMap<Integer, List<Edge>> top3Paths = new LinkedHashMap<Integer, List<Edge>>();
        for (int i = 0; i < paths.size(); ++i) {
            double cost = 0.0;
            Map<String, Edge> path = paths.get(i);
            String v = this.target.getName();
            while (!v.equals(this.source.getName())) {
                cost += path.get(v).getCost();
                v = path.get(v).getOther(network.get(v)).getName();
            }
            lowCost.put(i, cost);
        }
        Map sorted = NetworkFlow.sortByValues(lowCost);
        int numTopPaths = 0;
        for (Integer i : sorted.keySet()) {
            ArrayList<Edge> pathEdges = new ArrayList<Edge>();
            Map<String, Edge> path = paths.get(i);
            String v = this.target.getName();
            while (!v.equals(this.source.getName())) {
                pathEdges.add(path.get(v));
                v = path.get(v).getOther(network.get(v)).getName();
            }
            if (numPaths == -1) {
                top3Paths.put(i, pathEdges);
                continue;
            }
            if (numTopPaths >= numPaths) continue;
            top3Paths.put(i, pathEdges);
            ++numTopPaths;
        }
        return top3Paths;
    }

    public static <K extends Comparable, V extends Comparable> Map<K, V> sortByValues(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> entries = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                return ((Comparable)o1.getValue()).compareTo(o2.getValue());
            }
        });
        LinkedHashMap sortedMap = new LinkedHashMap();
        for (Map.Entry entry : entries) {
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    public void show(Map<Integer, Map<String, Edge>> auxPath, Map<String, Node> network) {
        for (int i = 0; i < auxPath.size(); ++i) {
            Map<String, Edge> path = auxPath.get(i);
            System.out.println("--------------------------------------");
            String v = this.target.getName();
            while (!v.equals(this.source.getName())) {
                System.out.println(path.get(v));
                v = path.get(v).getOther(network.get(v)).getName();
            }
            System.out.println("----------------------------------------");
        }
    }

    public Map<Integer, Map<String, Edge>> combinePaths(Map<Integer, Map<String, Edge>> pathSources, Map<Integer, Map<String, Edge>> pathSinks) {
        Integer n;
        Integer n2;
        int j;
        LinkedHashMap<Integer, Map<String, Edge>> combinedPaths = new LinkedHashMap<Integer, Map<String, Edge>>();
        Integer i = 0;
        for (j = 0; j < pathSources.size(); ++j) {
            n2 = i;
            n = i = Integer.valueOf(i + 1);
            combinedPaths.put(n2, pathSources.get(j));
        }
        for (j = 0; j < pathSinks.size(); ++j) {
            n2 = i;
            n = i = Integer.valueOf(i + 1);
            combinedPaths.put(n2, pathSinks.get(j));
        }
        return combinedPaths;
    }

    public void combineSubnets(Map<String, Node> subnetCombined, Map<String, Node> subnetSources, Map<String, Node> subnetSinks, String deletedGene) {
        Node from;
        ArrayList<Edge> sourceEdges = subnetSources.get("t").getEdges();
        ArrayList<Edge> sinkEdges = subnetSinks.get("t").getEdges();
        ArrayList<Node> sourceProteins = new ArrayList<Node>();
        ArrayList<Node> sinkProteins = new ArrayList<Node>();
        for (Edge e : sourceEdges) {
            from = new Node(e.getFrom().getName());
            from.setSymbol(e.getFrom().getSymbol());
            if (sinkProteins.contains(from)) continue;
            sourceProteins.add(from);
        }
        for (Edge e : sinkEdges) {
            from = new Node(e.getFrom().getName());
            from.setSymbol(e.getFrom().getSymbol());
            if (sourceProteins.contains(from)) continue;
            sinkProteins.add(from);
        }
        Node s = new Node("s");
        Node t = new Node("t");
        s.setSymbol("s");
        t.setSymbol("t");
        this.addSourceAndTarget(subnetCombined, s, t, sourceProteins, sinkProteins);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getGeneList(String file) throws IOException {
        ArrayList<String> geneList = new ArrayList<String>();
        int geneColumn = 1;
        try (BufferedReader in = null;){
            String line;
            in = new BufferedReader(new FileReader(file));
            in.readLine();
            while ((line = in.readLine()) != null) {
                String[] columns = line.split("\\,");
                String name = columns[geneColumn];
                String[] gene = name.split(" /// ");
                geneList.add(gene[0]);
            }
            ArrayList<String> arrayList = geneList;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSampleNames(String file) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        try (BufferedReader in = null;){
            String[] sampleNames;
            in = new BufferedReader(new FileReader(file));
            String line = in.readLine();
            for (String s : sampleNames = line.split("\t")) {
                if (s.equals("")) continue;
                names.add(s);
            }
            ArrayList<String> arrayList = names;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getArrays(String file, String state) throws IOException {
        try (BufferedReader in = null;){
            in = new BufferedReader(new FileReader(file));
            String line = in.readLine();
            List<String> firstLine = Arrays.asList(line.split("\t"));
            int index = firstLine.indexOf("description1");
            ArrayList<String> arrays = new ArrayList<String>();
            System.out.println(index + ": " + firstLine.get(index));
            while ((line = in.readLine()) != null) {
                String[] columns = line.split("\t");
                if (!columns[index].equals(state)) continue;
                arrays.add(columns[0]);
            }
            ArrayList<String> arrayList = arrays;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getArrays(String file, String state1, String state2) throws IOException {
        try (BufferedReader in = null;){
            in = new BufferedReader(new FileReader(file));
            String line = in.readLine();
            List<String> firstLine = Arrays.asList(line.split("\t"));
            int index = firstLine.indexOf("description1");
            ArrayList<String> arrays = new ArrayList<String>();
            System.out.println(index + ": " + firstLine.get(index));
            while ((line = in.readLine()) != null) {
                String[] columns = line.split("\t");
                if (!columns[index].equals(state1) && !columns[index].equals(state2)) continue;
                arrays.add(columns[0]);
            }
            ArrayList<String> arrayList = arrays;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseExpression(String file, Map<String, Map<String, Double>> exp1, String[] exp1Rep) throws IOException {
        try (BufferedReader in = null;){
            in = new BufferedReader(new FileReader(file));
            int[] iExp1 = new int[exp1Rep.length];
            String line = in.readLine();
            List<String> firstLine = Arrays.asList(line.split("\t"));
            for (int i = 0; i < exp1Rep.length; ++i) {
                int index;
                iExp1[i] = index = firstLine.indexOf(exp1Rep[i]);
                System.out.println(index + ": " + firstLine.get(iExp1[i]));
            }
            while ((line = in.readLine()) != null) {
                String[] columns = line.split("\t");
                LinkedHashMap<String, Double> map1 = new LinkedHashMap<String, Double>();
                for (int i = 0; i < iExp1.length; ++i) {
                    map1.put(exp1Rep[i], Double.valueOf(columns[iExp1[i]]));
                }
                exp1.put(columns[0], map1);
            }
        }
    }

    public Map<String, Double> calcMeanExpression(Map<String, Map<String, Double>> exp) {
        LinkedHashMap<String, Double> geneMean = new LinkedHashMap<String, Double>();
        for (String s : exp.keySet()) {
            ArrayList<Double> expression = new ArrayList<Double>(exp.get(s).values());
            double sum = 0.0;
            double mean = 0.0;
            for (Double d : expression) {
                sum += d.doubleValue();
            }
            mean = sum / (double)expression.size();
            geneMean.put(s, mean);
        }
        return geneMean;
    }

    public List<String> getSourcesSubnet(Map<String, Node> subnet) {
        ArrayList<String> proteins = new ArrayList<String>();
        ArrayList<Edge> edges = subnet.get("s").getEdges();
        for (Edge e : edges) {
            proteins.add(e.getTo().getName());
        }
        return proteins;
    }

    public ArrayList<String> getSinksSubnet(Map<String, Node> subnet) {
        ArrayList<String> proteins = new ArrayList<String>();
        ArrayList<Edge> edges = subnet.get("t").getEdges();
        for (Edge e : edges) {
            proteins.add(e.getFrom().getName());
        }
        return proteins;
    }

    public static Map<String, Integer> countGO(Map<String, Node> subnet) {
        LinkedHashMap<String, Integer> counting = new LinkedHashMap<String, Integer>();
        for (String s : subnet.keySet()) {
            Node n = subnet.get(s);
            if (s.equals("s")) continue;
            System.out.println("-----------" + n.getSymbol() + "----------");
            System.out.println("Total Flow: " + n.getTotalFlow());
            System.out.println("Out flow: " + n.getOutflow());
            Map<String, Double> outflow = n.getTopOutFlow();
            for (String out : outflow.keySet()) {
                if (out.equals("t")) continue;
                for (String g : subnet.get(out).getOutflowGOs()) {
                    if (counting.containsKey(g)) {
                        counting.put(g, (Integer)counting.get(g) + 1);
                        continue;
                    }
                    counting.put(g, 1);
                }
            }
        }
        return NetworkFlow.sortByValues(counting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Double> loadGOscores(String file) throws IOException {
        LinkedHashMap<String, Double> randomGOscores = new LinkedHashMap<String, Double>();
        BufferedReader in = null;
        int goColumn = 1;
        int scoreColumn = 3;
        try {
            String line;
            in = new BufferedReader(new FileReader(file));
            in.readLine();
            while ((line = in.readLine()) != null) {
                String[] columns = line.split("\t");
                String go = columns[goColumn];
                Double score = Double.valueOf(columns[scoreColumn]);
                randomGOscores.put(go, score);
            }
            LinkedHashMap<String, Double> linkedHashMap = randomGOscores;
            return linkedHashMap;
        }
        finally {
            in.close();
        }
    }

    public static Map<String, Double> countGOWeighted(Map<String, Node> subnet) {
        LinkedHashMap<String, Double> counting = new LinkedHashMap<String, Double>();
        for (String s : subnet.keySet()) {
            Node n = subnet.get(s);
            if (s.equals("s")) continue;
            Map<String, Double> outflow = n.getTopOutFlow();
            for (String out : outflow.keySet()) {
                if (out.equals("t")) continue;
                for (String g : subnet.get(out).getOutflowGOs()) {
                    if (counting.containsKey(g)) {
                        Double score = ((Double)counting.get(g) + 1.0) * outflow.get(out);
                        counting.put(g, score);
                        continue;
                    }
                    counting.put(g, 1.0 * outflow.get(out));
                }
            }
        }
        return NetworkFlow.sortByValues(counting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getGenes(String file) throws IOException {
        ArrayList<String> geneList = new ArrayList<String>();
        int geneColumn = 0;
        try (BufferedReader in = null;){
            String line;
            in = new BufferedReader(new FileReader(file));
            in.readLine();
            while ((line = in.readLine()) != null) {
                String[] columns = line.split("\\,");
                String gene = columns[geneColumn];
                geneList.add(gene);
            }
            ArrayList<String> arrayList = geneList;
            return arrayList;
        }
    }

    public Set<Integer> randomizeVector(List<String> proteins) {
        LinkedHashSet<Integer> randomNumbers = new LinkedHashSet<Integer>();
        int size = proteins.size();
        int max = proteins.size();
        int min = 0;
        System.out.println("creating random numbers");
        while (randomNumbers.size() < size) {
            Random rand = new Random();
            int randomNumber = rand.nextInt(max - min + min);
            randomNumbers.add(randomNumber);
        }
        System.out.println("done");
        return randomNumbers;
    }

    public Set<String> getRandomProteins(List<String> proteins, int size) {
        LinkedHashSet<String> randomProteins = new LinkedHashSet<String>();
        int max = proteins.size();
        int min = 0;
        System.out.println("obtaining " + size + " random proteins");
        while (randomProteins.size() < size) {
            Random rand = new Random();
            int randomNumber = rand.nextInt(max - min + min);
            randomProteins.add(proteins.get(randomNumber));
        }
        System.out.println("done");
        return randomProteins;
    }

    public List<List<Node>> selectSources(Set<String> sources, Set<String> sinks, List<String> proteinsA, List<String> proteinsB) {
        LinkedHashMap<String, Node> network = new LinkedHashMap<String, Node>();
        LinkedHashSet<Node> si = new LinkedHashSet<Node>();
        LinkedHashSet<Node> ti = new LinkedHashSet<Node>();
        for (int i = 0; i < proteinsA.size(); ++i) {
            Node proteinA = new Node(proteinsA.get(i));
            Node proteinB = new Node(proteinsB.get(i));
            proteinA.setSymbol(proteinA.getName());
            proteinB.setSymbol(proteinB.getName());
            Edge edge = new Edge(proteinA, proteinB);
            this.addEdge(network, edge);
        }
        for (String s : sources) {
            Node so = (Node)network.get(s);
            if (so == null) continue;
            si.add(so);
        }
        for (String u : sinks) {
            Node un = (Node)network.get(u);
            if (un == null || ti.contains(un) || si.contains(un)) continue;
            ti.add(un);
        }
        ArrayList<List<Node>> sourcesAndSinks = new ArrayList<List<Node>>();
        sourcesAndSinks.add(new ArrayList(si));
        sourcesAndSinks.add(new ArrayList(ti));
        return sourcesAndSinks;
    }

    public List<List<Node>> selectSources(Set<String> sinks, List<String> proteinsA, List<String> proteinsB) {
        LinkedHashMap<String, Node> network = new LinkedHashMap<String, Node>();
        LinkedHashSet<Node> si = new LinkedHashSet<Node>();
        LinkedHashSet<Node> ti = new LinkedHashSet<Node>();
        System.out.println("selecting sources...");
        System.out.println(proteinsA.size());
        System.out.println(proteinsB.size());
        for (int i = 0; i < proteinsA.size(); ++i) {
            Node proteinA = new Node(proteinsA.get(i));
            Node node = new Node(proteinsB.get(i));
            proteinA.setSymbol(proteinA.getName());
            node.setSymbol(node.getName());
            Edge edge = new Edge(proteinA, node);
            this.addEdge(network, edge);
        }
        System.out.println("network size: " + network.size());
        LinkedHashSet<String> sinkNames = new LinkedHashSet<String>();
        for (String string : sinks) {
            Node un = (Node)network.get(string);
            if (un == null) continue;
            if (!ti.contains(un)) {
                ti.add(un);
            }
            sinkNames.add(un.getName());
        }
        LinkedHashSet aux = new LinkedHashSet(network.keySet());
        aux.removeAll(sinkNames);
        for (String i : aux) {
            Node so = (Node)network.get(i);
            si.add(so);
        }
        System.out.println("souces: " + si.size());
        System.out.println("sinks: " + ti.size());
        ArrayList<List<Node>> arrayList = new ArrayList<List<Node>>();
        arrayList.add(new ArrayList(si));
        arrayList.add(new ArrayList(ti));
        return arrayList;
    }

    public void createNetwork(List<Node> sources, List<Node> sinks, Map<String, Node> network, List<String> proteinsA, List<String> proteinsB, List<Double> scores, List<Double> signScores) {
        Node s = new Node("s");
        Node t = new Node("t");
        s.setSymbol("s");
        t.setSymbol("t");
        for (int i = 0; i < proteinsA.size(); ++i) {
            Node proteinA = new Node(proteinsA.get(i));
            Node proteinB = new Node(proteinsB.get(i));
            proteinA.setSymbol(proteinA.getName());
            proteinB.setSymbol(proteinB.getName());
            Edge edge = new Edge(proteinA, proteinB);
            edge.setCapacity(scores.get(i));
            edge.setCost(-Math.log(scores.get(i)));
            edge.setMiscore(scores.get(i));
            edge.setSignScore(signScores.get(i));
            this.addEdge(network, edge);
        }
        System.out.println("Number of sources: " + sources.size());
        System.out.println("Number of sinks: " + sinks.size());
        System.out.println("Network size before: " + network.size());
        this.addSourceAndTarget(network, s, t, sources, sinks);
    }

    public Set<String> setUniversalSinksHuman(OntologyUtils utils, List<String> annotation, String file) throws IOException {
        LinkedHashSet<String> universalSinks = new LinkedHashSet<String>();
        InputOutput io = new InputOutput();
        Map<String, List<String>> map = io.mapGOtxt(file);
        for (String m : map.keySet()) {
            List<String> go = map.get(m);
            for (String a : annotation) {
                if (!go.contains(a)) continue;
                universalSinks.add(m);
            }
        }
        return universalSinks;
    }

    public void mappingNameToId(Map<String, Node> network) {
        int i = 0;
        this.symbolTable = new LinkedHashMap<String, Integer>();
        for (String p : network.keySet()) {
            this.symbolTable.put(p, i++);
        }
        this.keys = new String[this.symbolTable.size()];
        Iterator<String> iterator = this.symbolTable.keySet().iterator();
        while (iterator.hasNext()) {
            String s;
            this.keys[this.symbolTable.get((Object)s).intValue()] = s = iterator.next();
        }
    }

    public int E() {
        return this.E;
    }

    public void printNetwork(Map<String, Node> network) {
        String s = "";
        for (String p : network.keySet()) {
            s = s + network.get(p).getSymbol() + ": ";
            for (Edge e : network.get(p).getEdges()) {
                s = s + e.getFrom().getSymbol() + "-" + e.getTo().getSymbol() + " ";
            }
            s = s + "\n";
        }
        System.out.println(s);
    }

    public void saveRandomNetworkInteractions(Map<String, List<String>> matrix, List<Double> miscores, String file) throws FileNotFoundException {
        PrintWriter pw = new PrintWriter(new FileOutputStream(file));
        int i = 0;
        for (String s : matrix.keySet()) {
            List<String> neighbors = matrix.get(s);
            for (String n : neighbors) {
                pw.println(s + "\t" + n + "\t" + miscores.get(i++));
            }
        }
        pw.close();
    }

    public void saveSubNet(Map<String, Node> subnet, String file) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(file));
            pw.println("\nfrom\tto\tedge_flow\tcorrelation\tsign");
            for (String s : subnet.keySet()) {
                Node n = subnet.get(s);
                for (Edge e : n.getEdges()) {
                    Integer sign = 0;
                    sign = e.getSignScore() > 0.0 ? Integer.valueOf(1) : Integer.valueOf(-1);
                    if (edges.contains(e)) continue;
                    pw.println(e.getFrom().getSymbol() + "\t" + e.getTo().getSymbol() + "\t" + e.getFlow() + "\t" + e.getSignScore() + "\t" + sign);
                    edges.add(e);
                }
            }
            pw.close();
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
        System.out.println("Subnet size: " + subnet.size());
    }

    public boolean hasNode(Map<String, Node> network, Node node) {
        return network.containsKey(node.getName());
    }

    public boolean hasEdge(Map<String, Node> network, Edge edge) {
        if (!this.hasNode(network, edge.getFrom())) {
            return false;
        }
        return network.get(edge.getFrom().getName()).getEdges().contains(edge);
    }

    public void addNode(Map<String, Node> network, Node node) {
        if (!this.hasNode(network, node)) {
            network.put(node.getName(), node);
        }
    }

    public void addEdge(Map<String, Node> network, Edge edge) {
        if (!this.hasEdge(network, edge)) {
            ++this.E;
        }
        if (!this.hasNode(network, edge.getFrom())) {
            this.addNode(network, edge.getFrom());
        }
        if (!this.hasNode(network, edge.getTo())) {
            this.addNode(network, edge.getTo());
        }
        Edge edger = new Edge(edge.getTo(), edge.getFrom(), edge.getCapacity(), edge.getCost());
        edger.setMiscore(edge.getMiscore());
        edger.setSignScore(edge.getSignScore());
        network.get(edge.getFrom().getName()).addEdge(edge);
        network.get(edge.getFrom().getName()).addEdge(edger);
        network.get(edge.getTo().getName()).addEdge(edge);
        network.get(edge.getTo().getName()).addEdge(edger);
    }

    public Map<String, List<String>> filterGO(Map<String, OntologyUtils.Term> hierarchy, Map<String, List<String>> map) throws IOException {
        LinkedHashMap<String, List<String>> newMap = new LinkedHashMap<String, List<String>>();
        for (String k : map.keySet()) {
            ArrayList<String> newGO = new ArrayList<String>();
            for (String g : map.get(k)) {
                OntologyUtils.Term term = hierarchy.get(g);
                if (!term.getNamespace().equals("biological_process")) continue;
                newGO.add(term.getId());
            }
            newMap.put(k, newGO);
        }
        return newMap;
    }

    public void setGOHuman(Map<String, Node> network, OntologyUtils utils, String file) throws IOException {
        InputOutput io = new InputOutput();
        Map<String, List<String>> mapFull = io.mapGOtxt(file);
        Map<String, List<String>> map = this.filterGO(utils.getGOHierarchy(), mapFull);
        for (String n : network.keySet()) {
            Node v = network.get(n);
            if (n == null || !map.containsKey(n)) continue;
            ArrayList<String> auxGO = new ArrayList<String>();
            for (String s : map.get(n)) {
                auxGO.add(s);
            }
            v.setGeneOntology(auxGO);
            v.setCurrentGOs(new ArrayList<String>(auxGO));
        }
    }

    public Map<Integer, List<Edge>> buildSubnet(Map<String, Node> network, Map<String, Node> subnet, Map<Integer, Map<String, Edge>> allPaths) {
        Map path;
        int i;
        LinkedHashMap<Integer, Map<String, Edge>> auxPath = new LinkedHashMap<Integer, Map<String, Edge>>();
        int pathNum = 0;
        System.out.println("path size before: " + allPaths.size());
        for (i = 0; i < allPaths.size(); ++i) {
            path = allPaths.get(i);
            boolean flag = false;
            String v = this.target.getName();
            while (!v.equals(this.source.getName())) {
                if (path.get(v).getFlow() == 0.0) {
                    flag = true;
                    break;
                }
                v = ((Edge)path.get(v)).getOther(network.get(v)).getName();
            }
            if (flag) continue;
            auxPath.put(pathNum, path);
            ++pathNum;
        }
        System.out.println("path size after: " + auxPath.size());
        for (i = 0; i < auxPath.size(); ++i) {
            path = (Map)auxPath.get(i);
            String v = this.target.getName();
            while (!v.equals(this.source.getName())) {
                Node from = new Node(((Edge)path.get(v)).getFrom().getName());
                Node to = new Node(v);
                from.setSymbol(network.get(from.getName()).getSymbol());
                from.setGeneOntology(network.get(from.getName()).getGeneOntology());
                from.setCurrentGOs(network.get(from.getName()).getCurrentGOs());
                from.setOutflowGOs(network.get(from.getName()).getOutflowGOs());
                from.setFunctionalCategory(network.get(from.getName()).getFunctionalCategory());
                to.setSymbol(network.get(to.getName()).getSymbol());
                to.setGeneOntology(network.get(to.getName()).getGeneOntology());
                to.setCurrentGOs(network.get(to.getName()).getCurrentGOs());
                to.setOutflowGOs(network.get(to.getName()).getOutflowGOs());
                to.setFunctionalCategory(network.get(to.getName()).getFunctionalCategory());
                if (!this.hasNode(subnet, from)) {
                    this.addNode(subnet, from);
                }
                if (!this.hasNode(subnet, to)) {
                    this.addNode(subnet, to);
                }
                Edge e = new Edge(from, to);
                e.setCapacity(((Edge)path.get(v)).getCapacity());
                e.setMiscore(((Edge)path.get(v)).getMiscore());
                e.setFlow(((Edge)path.get(v)).getFlow());
                e.setCost(((Edge)path.get(v)).getCost());
                e.setSignScore(((Edge)path.get(v)).getSignScore());
                if (!subnet.get(from.getName()).getEdges().contains(e)) {
                    subnet.get(from.getName()).addEdge(e);
                }
                if (!subnet.get(to.getName()).getEdges().contains(e)) {
                    subnet.get(to.getName()).addEdge(e);
                }
                v = ((Edge)path.get(v)).getOther(network.get(v)).getName();
            }
        }
        Map<Integer, List<Edge>> pathsSubnet = this.getPaths(auxPath, subnet);
        return pathsSubnet;
    }

    public Edge getEdge(Map<String, Node> network, Edge e) {
        ArrayList<Edge> edges = network.get(e.getFrom().getName()).getEdges();
        System.out.println(edges);
        for (Edge es : network.get(e.getFrom().getName()).getEdges()) {
            if (!es.getFrom().getName().equals(e.getFrom().getName()) || !es.getTo().getName().equals(e.getTo().getName())) continue;
            return es;
        }
        return null;
    }

    public void convergeGO2Sink(Map<String, Node> subnet, Map<String, OntologyUtils.Term> hierarchy, Set<String> sinkGO) {
        subnet.get("t").setCurrentGOs(new ArrayList<String>(sinkGO));
        System.out.println("----GOs propagated from source to sink---");
        for (String s : sinkGO) {
            OntologyUtils.Term term = hierarchy.get(s);
            System.out.println(term.getId() + ": " + term.getName());
        }
    }

    public boolean compute(Map<String, Node> network, Map<Integer, Map<String, Edge>> allPaths, OntologyUtils utils, Set<String> sinkGO) throws IOException {
        System.out.println("Computing flow");
        boolean augmented = false;
        if (!this.isFeasible(network, this.source, this.target)) {
            System.out.println("Ferrou desde o inicio");
        }
        int i = 0;
        while (this.prim2(network, this.getNodesPath(), sinkGO)) {
            this.processPath(network, this.getNodesPath(), i, allPaths);
            this.check(network, this.source, this.target);
            augmented = true;
            ++i;
            if (allPaths.size() % 10 != 0) continue;
            System.out.println("Number of paths: " + allPaths.size());
        }
        return augmented;
    }

    public void processPath(Map<String, Node> network, Map<String, NodeInfo> nodesPath, int path, Map<Integer, Map<String, Edge>> allPaths) {
        double delta = Double.MAX_VALUE;
        String v = this.target.getName();
        while (!v.equals(this.source.getName())) {
            network.get(v).getOutflowGOs().addAll(network.get(v).getCurrentGOs());
            delta = Math.min(delta, this.edgeTo.get(v).residualCapacityTo(network.get(v)));
            v = this.edgeTo.get(v).getOther(network.get(v)).getName();
        }
        v = this.target.getName();
        while (!v.equals(this.source.getName())) {
            this.edgeTo.get(v).addResidualFlowTo(network.get(v), delta);
            v = this.edgeTo.get(v).getOther(network.get(v)).getName();
        }
        allPaths.put(path, new LinkedHashMap<String, Edge>(this.edgeTo));
        this.value += delta;
        v = this.target.getName();
        while (!v.equals(this.source.getName())) {
            if (!(!(this.edgeTo.get(v).getFlow() > 0.0) || v.equals(this.source.getName()) && v.equals(this.target.getName()))) {
                this.cost += this.edgeTo.get(v).getCost();
            }
            v = this.edgeTo.get(v).getOther(network.get(v)).getName();
        }
        nodesPath.clear();
    }

    public boolean prim2(Map<String, Node> network, Map<String, NodeInfo> nodes, Set<String> sinkGO) {
        this.resetNodesVisited(network);
        this.ipq = new IndexMinPQ(network.size());
        LinkedHashMap<String, Boolean> inqueue = new LinkedHashMap<String, Boolean>();
        this.distTo = new LinkedHashMap<String, Double>();
        this.edgeTo = new LinkedHashMap<String, Edge>();
        for (String n : network.keySet()) {
            inqueue.put(n, false);
        }
        for (String n : network.keySet()) {
            if (n.equals(this.source.getName())) {
                this.distTo.put(this.source.getName(), 0.0);
                this.ipq.insert(this.symbolTable.get(this.source.getName()), (Double)((Comparable)this.distTo.get(this.source.getName())));
                inqueue.put(this.source.getName(), true);
                continue;
            }
            this.distTo.put(n, (Double)Double.MAX_VALUE);
        }
        while (!this.ipq.isEmpty()) {
            Node u = network.get(this.keys[this.ipq.delMin()]);
            inqueue.put(u.getName(), false);
            Iterator<Edge> it = u.edges();
            while (it.hasNext()) {
                Edge e = it.next();
                Node v = network.get(e.getOther(u).getName());
                if (v.getName().equals(this.source.getName()) || v.getName().equals(u.getName()) || !(e.residualCapacityTo(v) > 0.0)) continue;
                double newDist = this.distTo.get(u.getName()) + Math.abs(e.getCost());
                if (0.0 <= newDist && newDist < this.distTo.get(v.getName()) && (!this.checkGOFullContextDependent(network, u, v, sinkGO) || u.getName().equals("s") || v.getName().equals("t"))) {
                    nodes.put(v.getName(), new NodeInfo(u.getName(), true));
                    this.distTo.put(v.getName(), newDist);
                    this.edgeTo.put(v.getName(), e);
                    if (((Boolean)inqueue.get(v.getName())).booleanValue()) {
                        this.ipq.decreaseKey(this.symbolTable.get(v.getName()), newDist);
                    } else {
                        this.ipq.insert(this.symbolTable.get(v.getName()), newDist);
                        inqueue.put(v.getName(), true);
                    }
                }
                if (!v.getName().equals(this.target.getName())) continue;
                return true;
            }
        }
        return this.distTo.get(this.target.getName()) != Double.MAX_VALUE;
    }

    public Map<Integer, List<Edge>> getPaths(Map<Integer, Map<String, Edge>> paths, Map<String, Node> network) {
        LinkedHashMap<Integer, List<Edge>> allSinglePaths = new LinkedHashMap<Integer, List<Edge>>();
        for (int i = 0; i < paths.size(); ++i) {
            ArrayList<Edge> singlePath = new ArrayList<Edge>();
            Map<String, Edge> path = paths.get(i);
            String v = this.target.getName();
            while (!v.equals(this.source.getName())) {
                Edge e = path.get(v);
                singlePath.add(e);
                this.cost += e.getCost();
                v = path.get(v).getOther(network.get(v)).getName();
            }
            allSinglePaths.put(i, singlePath);
        }
        return allSinglePaths;
    }

    public Map<Integer, List<String>> showPaths(Map<Integer, Map<String, Edge>> paths, Map<String, Node> network) {
        LinkedHashMap<Integer, List<String>> allSinglePaths = new LinkedHashMap<Integer, List<String>>();
        for (int i = 0; i < paths.size(); ++i) {
            ArrayList<String> singlePath = new ArrayList<String>();
            Map<String, Edge> path = paths.get(i);
            String v = this.target.getName();
            while (!v.equals(this.source.getName())) {
                Edge e = path.get(v);
                if (e.getTo().getName().equals("t")) {
                    singlePath.add(e.getTo().getName());
                } else if (e.getFrom().getName().equals("s")) {
                    // empty if block
                }
                singlePath.add(e.getFrom().getSymbol());
                this.cost += e.getCost();
                v = path.get(v).getOther(network.get(v)).getName();
            }
            allSinglePaths.put(i, singlePath);
        }
        return allSinglePaths;
    }

    public boolean shortestPaths(Map<String, Node> network, Map<String, NodeInfo> nodes, Set<String> sinkGO) {
        this.resetNodesVisited(network);
        this.edgeTo = new LinkedHashMap<String, Edge>();
        Queue<Node> queue = new Queue<Node>();
        this.source.setVisited(true);
        queue.enqueue(this.source);
        while (!queue.isEmpty()) {
            Node u = network.get(((Node)queue.dequeue()).getName());
            Iterator<Edge> it = u.edges();
            while (it.hasNext()) {
                Edge e = it.next();
                Node v = network.get(e.getOther(u).getName());
                if (v.getName().equals(this.source.getName()) || v.getName().equals(u.getName()) || !(e.residualCapacityTo(v) > 0.0)) continue;
                if (!v.isVisited() && (!this.checkGOFullContextDependent(network, u, v, sinkGO) || u.getName().equals("s") || v.getName().equals("t"))) {
                    this.edgeTo.put(v.getName(), e);
                    v.setVisited(true);
                    queue.enqueue(v);
                }
                if (!v.getName().equals(this.target.getName())) continue;
                return true;
            }
        }
        return this.target.isVisited();
    }

    public boolean checkGOHalfContextDependent(Map<String, Node> network, Node u, Node v, Set<String> sinkGO) {
        ArrayList<String> vContext = new ArrayList<String>(v.getGOContext(network, 0.8));
        ArrayList<String> ont = new ArrayList<String>(this.union(vContext, v.getGeneOntology()));
        ArrayList<String> intersect = this.intersect(u.getCurrentGOs(), ont);
        if (u.getName().equals("s")) {
            v.setCurrentGOs(new ArrayList<String>(v.getGeneOntology()));
        } else if (v.getName().equals("t")) {
            v.setCurrentGOs(u.getCurrentGOs());
            for (String c : v.getCurrentGOs()) {
                sinkGO.add(c);
            }
        } else {
            v.setCurrentGOs(intersect);
        }
        return intersect.isEmpty();
    }

    public boolean checkGOFullContextDependent(Map<String, Node> network, Node u, Node v, Set<String> sinkGO) {
        ArrayList<String> uContext = new ArrayList<String>(u.getGOContext(network, 0.95));
        ArrayList<String> vContext = new ArrayList<String>(v.getGOContext(network, 0.95));
        ArrayList<String> ont = new ArrayList<String>(this.union(vContext, v.getGeneOntology()));
        ArrayList<String> uvContext = this.intersect(uContext, vContext);
        for (String uv : uvContext) {
            if (network.get(u.getName()).getCurrentGOs().contains(uv)) continue;
            network.get(u.getName()).getCurrentGOs().add(uv);
        }
        ArrayList<String> intersect = this.intersect(u.getCurrentGOs(), ont);
        if (u.getName().equals("s")) {
            network.get(v.getName()).setCurrentGOs(new ArrayList<String>(network.get(v.getName()).getGeneOntology()));
        } else if (v.getName().equals("t")) {
            network.get(v.getName()).setCurrentGOs(network.get(u.getName()).getCurrentGOs());
            for (String c : v.getCurrentGOs()) {
                sinkGO.add(c);
            }
        } else if (!intersect.isEmpty()) {
            network.get(v.getName()).setCurrentGOs(intersect);
        }
        return intersect.isEmpty();
    }

    public ArrayList<String> intersect(ArrayList<String> list1, ArrayList<String> list2) {
        ArrayList<String> intersection = new ArrayList<String>();
        for (String s : list1) {
            if (!list2.contains(s)) continue;
            intersection.add(s);
        }
        return intersection;
    }

    public Set<String> union(ArrayList<String> list1, ArrayList<String> list2) {
        LinkedHashSet<String> union = new LinkedHashSet<String>();
        union.addAll(list1);
        union.addAll(list2);
        return union;
    }

    public void resetNodesVisited(Map<String, Node> network) {
        for (String n : network.keySet()) {
            network.get(n).setVisited(false);
            ArrayList<String> go = new ArrayList<String>(network.get(n).getGeneOntology());
            network.get(n).setCurrentGOs(go);
        }
    }

    public void addSourceAndTarget(Map<String, Node> network, Node newSource, Node newTarget, List<Node> sources, List<Node> targets) {
        Object newEdge;
        double cap;
        ArrayList<Edge> edges = null;
        Node edgesSource = new Node(newSource.getName());
        Node edgesTarget = new Node(newTarget.getName());
        for (Node s : sources) {
            edges = network.get(s.getName()).getEdges();
            cap = 0.0;
            for (Edge e : edges) {
                cap += e.getCapacity();
            }
            newEdge = new Edge(newSource, s, cap, 0.0);
            edges.add((Edge)newEdge);
            edgesSource.addEdge((Edge)newEdge);
        }
        for (Node t : targets) {
            if (network.get(t.getName()) == null) continue;
            edges = network.get(t.getName()).getEdges();
            cap = 0.0;
            for (Edge e : edges) {
                cap += e.getCapacity();
            }
            newEdge = new Edge(t, newTarget, cap, 0.0);
            edges.add((Edge)newEdge);
            edgesTarget.addEdge((Edge)newEdge);
        }
        this.add(network, 0, newSource.getName(), edgesSource);
        network.put(newTarget.getName(), edgesTarget);
        network.get(newSource.getName()).setSymbol("s");
        network.get(newTarget.getName()).setSymbol("t");
        System.out.println("New source " + newSource.getSymbol() + " added");
        System.out.println("New target " + newTarget.getSymbol() + " added");
        this.setSource(newSource);
        this.setTarget(newTarget);
        System.out.println("Network size: " + network.size());
    }

    public void add(Map<String, Node> map, int index, String key, Node value) {
        int i = 0;
        ArrayList<Map.Entry<String, Node>> rest = new ArrayList<Map.Entry<String, Node>>();
        for (Map.Entry<String, Node> entry : map.entrySet()) {
            if (i++ < index) continue;
            rest.add(entry);
        }
        map.put(key, value);
        for (int j = 0; j < rest.size(); ++j) {
            Map.Entry entry = (Map.Entry)rest.get(j);
            map.remove(entry.getKey());
            map.put((String)entry.getKey(), (Node)entry.getValue());
        }
    }

    private boolean excess(Node v) {
        double excess = 0.0;
        for (Edge e : v.getEdges()) {
            if (v.getName().equals(e.getFrom().getName())) {
                excess -= e.getFlow();
                continue;
            }
            excess += e.getFlow();
        }
        return Math.abs(excess) < 1.0E-11;
    }

    private boolean isFeasible(Map<String, Node> network, Node s, Node t) {
        double EPSILON = 1.0E-11;
        for (String v : network.keySet()) {
            for (Edge e : network.get(v).getEdges()) {
                if (!(e.getFlow() < -EPSILON) && !(e.getFlow() > e.getCapacity() + EPSILON)) continue;
                System.out.println(e);
                System.out.println("Capacity constraints are not satisfied");
                return false;
            }
        }
        for (String v : network.keySet()) {
            if (v.equals(this.source.getName()) || v.equals(this.target.getName()) || this.excess(network.get(v))) continue;
            System.out.println("Flow equilibrium condition is not satisfied");
            return false;
        }
        return true;
    }

    public boolean inCut(Node v) {
        return v.isVisited();
    }

    public boolean check(Map<String, Node> network, Node s, Node t) {
        if (!this.isFeasible(network, s, t)) {
            System.out.println("Flow is not feasible");
            return false;
        }
        return true;
    }

    public Node getSource() {
        return this.source;
    }

    public void setSource(Node source) {
        this.source = source;
    }

    public Node getTarget() {
        return this.target;
    }

    public void setTarget(Node target) {
        this.target = target;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public Map<String, NodeInfo> getNodesPath() {
        return this.nodesPath;
    }

    public void setNodesPath(Map<String, NodeInfo> nodesPath) {
        this.nodesPath = nodesPath;
    }
}

