/*
 * Decompiled with CFR 0.152.
 */
package netdecoder;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import netdecoder.Edge;
import netdecoder.NetworkFlow;
import netdecoder.Node;
import netdecoder.Path;
import netdecoder.RJava;
import netdecoder.Serialization;

public class NetDecoderUtils {
    public static void combineFiles(List<String> files, String combinedFile) {
        FileWriter fstream = null;
        BufferedWriter out = null;
        try {
            File mergedFile = new File(combinedFile);
            fstream = new FileWriter(mergedFile, true);
            out = new BufferedWriter(fstream);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        for (String file : files) {
            File f = new File(file);
            System.out.println("merging: " + f.getName());
            try {
                String aLine;
                FileInputStream fis = new FileInputStream(f);
                BufferedReader in = new BufferedReader(new InputStreamReader(fis));
                while ((aLine = in.readLine()) != null) {
                    out.write(aLine);
                    out.newLine();
                }
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getNumEdges(Map<String, Node> network) {
        int numEdges = 0;
        for (String n : network.keySet()) {
            Node p = network.get(n);
            numEdges += p.getEdges().size();
        }
        System.out.println("NUMBER OF EDGES" + numEdges);
    }

    public static void savePaths(List<Path> paths, String file) throws IOException {
        try {
            File f = new File(file);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("path\tpath_cost\tpath_flow");
            bw.newLine();
            for (Path p : paths) {
                Path rPath = p.reversePath();
                bw.write(rPath.toString() + "\t" + p.cost + "\t" + p.flow);
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException io) {
            throw new IOException("Trouble creating or writing to " + file);
        }
    }

    public static void saveTotalFlow(Map<String, Node> network, String head, String file) throws IOException {
        File f = new File(file);
        if (!f.exists()) {
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(head + "\t" + "netflow");
        bw.newLine();
        for (String n : network.keySet()) {
            Node n1 = network.get(n);
            bw.write(n1.getSymbol() + "\t" + n1.getTotalFlow());
            bw.newLine();
        }
        bw.close();
    }

    public static void saveTotalFlowByCategory(Map<String, Node> network, String comparison, List<Node> proteins, String head, String file) throws IOException {
        File f = new File(file);
        if (!f.exists()) {
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("comparison\t" + head + "\t" + "netflow");
        bw.newLine();
        for (Node n : proteins) {
            String aux = n.getSymbol().split("\\/")[0];
            bw.write(comparison + "\t" + aux + "\t" + n.getTotalFlow());
            bw.newLine();
        }
        bw.close();
    }

    public static List<Node> getTopSources(Map<String, Node> subnet, int top) {
        ArrayList<Node> proteins = new ArrayList<Node>();
        ArrayList<Edge> edges = subnet.get("s").getEdges();
        for (Edge e : edges) {
            proteins.add(subnet.get(e.getTo().getName()));
        }
        Collections.sort(proteins, (n1, n2) -> Double.compare(n1.getTotalFlow(), n2.getTotalFlow()));
        List<Node> topProteins = proteins.subList(proteins.size() - top, proteins.size());
        return topProteins;
    }

    public static Map<String, Double> getSources(Map<String, Node> subnet, int top) {
        ArrayList<Node> proteins = new ArrayList<Node>();
        ArrayList<Edge> edges = subnet.get("s").getEdges();
        for (Edge e : edges) {
            proteins.add(subnet.get(e.getTo().getName()));
        }
        Collections.sort(proteins, (n1, n2) -> Double.compare(n1.getTotalFlow(), n2.getTotalFlow()));
        List<Node> auxProteins = null;
        auxProteins = proteins.size() < top + 1 ? proteins : proteins.subList(proteins.size() - top, proteins.size());
        LinkedHashMap<String, Double> topProteins = new LinkedHashMap<String, Double>();
        for (Node n : auxProteins) {
            topProteins.put(n.getSymbol(), n.getTotalFlow());
        }
        return topProteins;
    }

    public static Map<String, Double> getTotalFlow(Map<String, Node> subnet) {
        LinkedHashMap<String, Double> totalFlow = new LinkedHashMap<String, Double>();
        for (String n : subnet.keySet()) {
            Node node = subnet.get(n);
            totalFlow.put(node.getSymbol(), node.getTotalFlow());
        }
        return totalFlow;
    }

    public static Map<String, Double> getSinks(Map<String, Node> subnet) {
        ArrayList<Node> proteins = new ArrayList<Node>();
        ArrayList<Edge> edges = subnet.get("t").getEdges();
        for (Edge e : edges) {
            proteins.add(subnet.get(e.getFrom().getName()));
        }
        LinkedHashMap<String, Double> totalFlow = new LinkedHashMap<String, Double>();
        for (Node n : proteins) {
            totalFlow.put(n.getSymbol(), n.getTotalFlow());
        }
        return totalFlow;
    }

    public static Map<String, Double> getSources(Map<String, Node> subnet) {
        ArrayList<Node> proteins = new ArrayList<Node>();
        ArrayList<Edge> edges = subnet.get("s").getEdges();
        for (Edge e : edges) {
            proteins.add(subnet.get(e.getTo().getName()));
        }
        LinkedHashMap<String, Double> totalFlow = new LinkedHashMap<String, Double>();
        for (Node n : proteins) {
            totalFlow.put(n.getSymbol(), n.getTotalFlow());
        }
        return totalFlow;
    }

    public static Map<String, Double> getHiddenProteins(Map<String, Node> subnet) {
        ArrayList<String> proteins = new ArrayList<String>(subnet.keySet());
        Set<String> sources = NetDecoderUtils.getSources(subnet).keySet();
        Set<String> sinks = NetDecoderUtils.getSinks(subnet).keySet();
        proteins.removeAll(sources);
        proteins.removeAll(sinks);
        proteins.remove("t");
        proteins.remove("s");
        LinkedHashMap<String, Double> totalFlow = new LinkedHashMap<String, Double>();
        for (String n : proteins) {
            totalFlow.put(n, subnet.get(n).getTotalFlow());
        }
        return totalFlow;
    }

    public static Map<String, Double> getSinks(Map<String, Node> subnet, int top) {
        ArrayList<Node> proteins = new ArrayList<Node>();
        ArrayList<Edge> edges = subnet.get("t").getEdges();
        for (Edge e : edges) {
            proteins.add(subnet.get(e.getFrom().getName()));
        }
        Collections.sort(proteins, (n1, n2) -> Double.compare(n1.getTotalFlow(), n2.getTotalFlow()));
        List<Node> auxProteins = null;
        auxProteins = proteins.size() < top + 1 ? proteins : proteins.subList(proteins.size() - top, proteins.size());
        LinkedHashMap<String, Double> topProteins = new LinkedHashMap<String, Double>();
        for (Node n : auxProteins) {
            topProteins.put(n.getSymbol(), n.getTotalFlow());
        }
        return topProteins;
    }

    public static List<Node> getTopSinks(Map<String, Node> subnet, int top) {
        ArrayList<Node> proteins = new ArrayList<Node>();
        ArrayList<Edge> edges = subnet.get("t").getEdges();
        for (Edge e : edges) {
            proteins.add(subnet.get(e.getFrom().getName()));
        }
        Collections.sort(proteins, (n1, n2) -> Double.compare(n1.getTotalFlow(), n2.getTotalFlow()));
        List<Node> topProteins = proteins.subList(proteins.size() - top, proteins.size());
        return topProteins;
    }

    public static List<String> transformPaths2String(List<Path> paths) {
        ArrayList<String> auxPaths = new ArrayList<String>();
        for (Path p : paths) {
            auxPaths.add(NetDecoderUtils.convertPath2String(p.getPath(), true));
        }
        return auxPaths;
    }

    public static List<Path> transform2Paths(List<List<Edge>> paths) {
        ArrayList<Path> newPaths = new ArrayList<Path>();
        for (List<Edge> path : paths) {
            Path p = new Path(path);
            newPaths.add(p);
        }
        return newPaths;
    }

    public static int intersection(List<String> list1, List<String> list2) {
        ArrayList<String> intersection = new ArrayList<String>();
        for (String s : list1) {
            if (!list2.contains(s)) continue;
            intersection.add(s);
        }
        return intersection.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<String>> mapGO2Genes(String file) throws IOException {
        LinkedHashMap<String, List<String>> go2genes = new LinkedHashMap<String, List<String>>();
        try (BufferedReader in = null;){
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                String[] columns = line.split("\t");
                String uniprot = columns[1];
                String goID = columns[4];
                if (!go2genes.containsKey(goID)) {
                    ArrayList<String> genes = new ArrayList<String>();
                    genes.add(uniprot);
                    go2genes.put(goID, genes);
                    continue;
                }
                ((List)go2genes.get(goID)).add(uniprot);
            }
            LinkedHashMap<String, List<String>> linkedHashMap = go2genes;
            return linkedHashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<String>> mapGO2uniprot(String file) throws IOException {
        LinkedHashMap<String, List<String>> go2genes = new LinkedHashMap<String, List<String>>();
        try (BufferedReader in = null;){
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                String[] columns = line.split("\t");
                String uniprot = "uniprotkb:" + columns[1];
                String goID = columns[4];
                if (!go2genes.containsKey(goID)) {
                    ArrayList<String> genes = new ArrayList<String>();
                    genes.add(uniprot);
                    go2genes.put(goID, genes);
                    continue;
                }
                ((List)go2genes.get(goID)).add(uniprot);
            }
            LinkedHashMap<String, List<String>> linkedHashMap = go2genes;
            return linkedHashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, List<String>> mapGenes2GO(String file) throws IOException {
        LinkedHashMap<String, List<String>> genes2go = new LinkedHashMap<String, List<String>>();
        try (BufferedReader in = null;){
            String line;
            in = new BufferedReader(new FileReader(file));
            while ((line = in.readLine()) != null) {
                String[] columns = line.split("\t");
                String uniprot = columns[1];
                String goID = columns[4];
                if (!genes2go.containsKey(uniprot)) {
                    ArrayList<String> gos = new ArrayList<String>();
                    gos.add(goID);
                    genes2go.put(uniprot, gos);
                    continue;
                }
                ((List)genes2go.get(uniprot)).add(goID);
            }
            LinkedHashMap<String, List<String>> linkedHashMap = genes2go;
            return linkedHashMap;
        }
    }

    public static void saveCCS(Map<String, Double> contributionScore, String diseaseState, String file) throws IOException {
        File f = new File(file);
        if (!f.exists()) {
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("expression\t" + diseaseState);
        bw.newLine();
        boolean column = false;
        for (String gene : contributionScore.keySet()) {
            bw.write(gene + "\t" + contributionScore.get(gene));
            bw.newLine();
        }
        bw.close();
    }

    public static List<Path> getPhenotypeSpecificPaths(List<String> pathsDisease, List<String> pathsControl) {
        List<Path> auxDisease = NetDecoderUtils.convertString2Paths(pathsDisease);
        List<Path> auxControl = NetDecoderUtils.convertString2Paths(pathsControl);
        auxDisease.removeAll(auxControl);
        return auxDisease;
    }

    public static List<Path> convertString2Paths(List<String> pathsDisease) {
        ArrayList<Path> auxPaths = new ArrayList<Path>();
        for (String path : pathsDisease) {
            auxPaths.add(NetDecoderUtils.convertString2Path(path));
        }
        return auxPaths;
    }

    public static Map<Node, Map<Node, Integer>> createAdjacencyMatrix(Map<String, Node> network) {
        LinkedHashMap<Node, Map<Node, Integer>> adj = new LinkedHashMap<Node, Map<Node, Integer>>();
        for (String p1 : network.keySet()) {
            Node protein = network.get(p1);
            List<Node> neigh = NetDecoderUtils.getNeighbors(protein);
            LinkedHashMap<Node, Integer> aux = new LinkedHashMap<Node, Integer>();
            for (String p2 : network.keySet()) {
                Node protein2 = network.get(p2);
                if (neigh.contains(protein2)) {
                    aux.put(protein2, 1);
                    continue;
                }
                aux.put(protein2, 0);
            }
            adj.put(protein, aux);
        }
        return adj;
    }

    public static List<Node> getNeighbors(Node protein) {
        ArrayList<Node> neigh = new ArrayList<Node>();
        for (Edge e : protein.getEdges()) {
            neigh.add(e.getOther(protein));
        }
        return neigh;
    }

    public static List<String> getPathsFromGenes(Map<String, Node> network, List<String> networkPaths, List<String> genes, RJava rJava, String dir, String filename) throws IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ArrayList<String> scripts = new ArrayList<String>();
        for (String d : genes) {
            ArrayList<String> stringPath = new ArrayList<String>();
            if (network.containsKey(d)) {
                LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>(network.get(d).getEdges());
                Map<Edge, List<Path>> edge2path = NetDecoderUtils.getPathsFromEdges(networkPaths, edges);
                for (Edge e : edge2path.keySet()) {
                    for (Path p : edge2path.get(e)) {
                        stringPath.add(NetDecoderUtils.convertPath2String(p.getPath(), true));
                    }
                }
            }
            if (stringPath.isEmpty()) continue;
            Map<String, Node> subnet = NetDecoderUtils.createNetworkFromPaths(stringPath);
            NetDecoderUtils.saveAdjMatrix(NetDecoderUtils.createAdjacencyMatrix(subnet), filename + "_" + d + ".txt");
            scripts.add(rJava.createAdjAdjMatrixScript("", filename + "_" + d, d));
        }
        return scripts;
    }

    public static void getJaccardIndex(Map<String, Node> network, List<Node> nodes, String filename) {
        LinkedHashSet<String> proteins = new LinkedHashSet<String>();
        for (Node n : nodes) {
            proteins.add(n.getName());
        }
        System.out.println("proteins: " + proteins.size());
        proteins.retainAll(network.keySet());
        proteins.retainAll(network.keySet());
        System.out.println("proteins: " + proteins.size());
        NetworkFlow net = new NetworkFlow();
        LinkedHashMap<String, Map<String, Double>> similarityMatrix = new LinkedHashMap<String, Map<String, Double>>();
        for (String c : proteins) {
            Node diseaseProtein = network.get(c);
            ArrayList<String> neigh = new ArrayList<String>(diseaseProtein.getNeighborsBasedOnFlow(0.0));
            for (String e : proteins) {
                Node controlProtein = network.get(e);
                ArrayList<String> neigh2 = new ArrayList<String>(controlProtein.getNeighborsBasedOnFlow(0.0));
                ArrayList<String> inter = net.intersect(neigh, neigh2);
                Set<String> union = net.union(neigh, neigh2);
                double jaccard = 0.0;
                jaccard = inter.isEmpty() && union.isEmpty() ? 1.0 : Double.valueOf(inter.size()) / Double.valueOf(union.size());
                System.out.println(diseaseProtein.getSymbol() + "\t" + controlProtein.getSymbol() + "\t" + jaccard);
                if (!similarityMatrix.containsKey(diseaseProtein.getSymbol())) {
                    LinkedHashMap<String, Double> auxSimilarityMatrix = new LinkedHashMap<String, Double>();
                    auxSimilarityMatrix.put(controlProtein.getSymbol(), jaccard);
                    similarityMatrix.put(diseaseProtein.getSymbol(), auxSimilarityMatrix);
                    continue;
                }
                ((Map)similarityMatrix.get(diseaseProtein.getSymbol())).put(controlProtein.getSymbol(), jaccard);
            }
        }
        NetDecoderUtils.saveJaccard(similarityMatrix, filename);
    }

    public static void getJaccardIndex(Map<String, Node> diseaseNetwork, Map<String, Node> controlNetwork, Set<Edge> keyEdges, String filename) {
        LinkedHashSet<String> proteins = new LinkedHashSet<String>();
        for (Edge e : keyEdges) {
            proteins.add(e.getFrom().getName());
            proteins.add(e.getTo().getName());
        }
        System.out.println("proteins: " + proteins.size());
        proteins.retainAll(diseaseNetwork.keySet());
        proteins.retainAll(controlNetwork.keySet());
        System.out.println("proteins: " + proteins.size());
        NetworkFlow net = new NetworkFlow();
        LinkedHashMap<String, Map<String, Double>> similarityMatrix = new LinkedHashMap<String, Map<String, Double>>();
        for (String c : proteins) {
            Node diseaseProtein = diseaseNetwork.get(c);
            ArrayList<String> neigh = new ArrayList<String>(diseaseProtein.getNeighborsBasedOnFlow(0.0));
            for (String e : proteins) {
                Node controlProtein = controlNetwork.get(e);
                ArrayList<String> neigh2 = new ArrayList<String>(controlProtein.getNeighborsBasedOnFlow(0.0));
                ArrayList<String> inter = net.intersect(neigh, neigh2);
                Set<String> union = net.union(neigh, neigh2);
                double jaccard = 0.0;
                jaccard = inter.isEmpty() && union.isEmpty() ? 1.0 : Double.valueOf(inter.size()) / Double.valueOf(union.size());
                System.out.println(diseaseProtein.getSymbol() + "\t" + controlProtein.getSymbol() + "\t" + jaccard);
                if (!similarityMatrix.containsKey(diseaseProtein.getSymbol())) {
                    LinkedHashMap<String, Double> auxSimilarityMatrix = new LinkedHashMap<String, Double>();
                    auxSimilarityMatrix.put(controlProtein.getSymbol(), jaccard);
                    similarityMatrix.put(diseaseProtein.getSymbol(), auxSimilarityMatrix);
                    continue;
                }
                ((Map)similarityMatrix.get(diseaseProtein.getSymbol())).put(controlProtein.getSymbol(), jaccard);
            }
        }
        NetDecoderUtils.saveJaccard(similarityMatrix, filename);
    }

    public static void getJaccardIndex(Map<String, Node> diseaseNetwork, Map<String, Node> controlNetwork, String filename) {
        LinkedHashSet<String> proteins = new LinkedHashSet<String>(diseaseNetwork.keySet());
        proteins.retainAll(controlNetwork.keySet());
        NetworkFlow net = new NetworkFlow();
        LinkedHashMap<String, Map<String, Double>> similarityMatrix = new LinkedHashMap<String, Map<String, Double>>();
        for (String c : proteins) {
            Node diseaseProtein = diseaseNetwork.get(c);
            ArrayList<String> neigh = new ArrayList<String>(diseaseProtein.getNeighborsBasedOnFlow(0.0));
            LinkedHashMap<String, Double> auxSimilarityMatrix = new LinkedHashMap<String, Double>();
            for (String e : proteins) {
                Node controlProtein = controlNetwork.get(e);
                ArrayList<String> neigh2 = new ArrayList<String>(controlProtein.getNeighborsBasedOnFlow(0.0));
                ArrayList<String> inter = net.intersect(neigh, neigh2);
                Set<String> union = net.union(neigh, neigh2);
                double jaccard = inter.isEmpty() && union.isEmpty() ? 1.0 : (double)(inter.size() / union.size());
                auxSimilarityMatrix.put(controlProtein.getSymbol(), jaccard);
            }
            similarityMatrix.put(diseaseProtein.getSymbol(), auxSimilarityMatrix);
        }
        NetDecoderUtils.saveJaccard(similarityMatrix, filename);
    }

    public static Path convertString2Path(String auxPath) {
        String[] auxEdges = auxPath.split("\\,");
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (int i = 0; i < auxEdges.length; ++i) {
            Node from = new Node(auxEdges[i].split("\\->")[0]);
            Node to = new Node(auxEdges[i].split("\\->")[1]);
            from.setSymbol(from.getName());
            to.setSymbol(to.getName());
            Double flow = Double.valueOf(auxEdges[i].split("\\->")[2]);
            Double signScore = Double.valueOf(auxEdges[i].split("\\->")[3]);
            Double cost = Double.valueOf(auxEdges[i].split("\\->")[4]);
            Edge e = new Edge(from, to);
            e.setFlow(flow);
            e.setSignScore(signScore);
            e.setCost(cost);
            edges.add(e);
        }
        return new Path(edges);
    }

    public static Map<Edge, List<Path>> getPathsFromEdges(List<String> networkPaths, Set<Edge> edges) {
        NetworkFlow net = new NetworkFlow();
        LinkedHashMap<Edge, List<Path>> edge2paths = new LinkedHashMap<Edge, List<Path>>();
        for (Edge e : edges) {
            ArrayList<Path> paths = new ArrayList<Path>();
            ArrayList<String> auxPaths = new ArrayList<String>();
            for (String s : networkPaths) {
                Path path = NetDecoderUtils.convertString2Path(s);
                if (!path.getPath().contains(e)) continue;
                auxPaths.add(s);
                paths.add(path);
            }
            edge2paths.put(e, paths);
        }
        return edge2paths;
    }

    public static Map<Node, Map<Node, Double>> createMatrix(Map<String, Node> network) {
        LinkedHashMap<Node, Map<Node, Double>> adj = new LinkedHashMap<Node, Map<Node, Double>>();
        for (String p1 : network.keySet()) {
            Node protein1 = network.get(p1);
            LinkedHashMap<Node, Double> aux = new LinkedHashMap<Node, Double>();
            List<Node> neigh = NetDecoderUtils.getNeighbors(protein1);
            for (String p2 : network.keySet()) {
                Node protein2 = network.get(p2);
                if (neigh.contains(protein2)) {
                    Edge e1 = new Edge(protein1, protein2);
                    Edge e2 = new Edge(protein2, protein1);
                    Edge rE1 = NetDecoderUtils.getEdge(network, e1);
                    Edge rE2 = NetDecoderUtils.getEdge(network, e2);
                    if (rE1 != null) {
                        aux.put(protein2, rE1.getFlow());
                        continue;
                    }
                    aux.put(protein2, rE2.getFlow());
                    continue;
                }
                aux.put(protein2, 0.0);
            }
            adj.put(protein1, aux);
        }
        return adj;
    }

    public static void saveMatrix(Map<Node, Map<Node, Double>> flowMatrix, String file) throws IOException {
        File f = new File(file);
        if (!f.exists()) {
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        boolean i = false;
        for (Node gene : flowMatrix.keySet()) {
            Map<Node, Double> netflow = flowMatrix.get(gene);
            if (!i) {
                for (Node protein : netflow.keySet()) {
                    String auxSymbol = protein.getSymbol().split("\\/")[0];
                    String symbol = auxSymbol.replace("-", "_");
                    bw.write("\t" + symbol);
                }
                bw.newLine();
                i = true;
            }
            String auxSymbol = gene.getSymbol().split("\\/")[0];
            String symbol = auxSymbol.replace("-", "_");
            bw.write(symbol);
            for (Node protein : netflow.keySet()) {
                bw.write("\t" + netflow.get(protein));
            }
            bw.newLine();
        }
        bw.close();
    }

    public static void comparePaths(Map<Edge, List<Path>> diseaseEdges, Map<Edge, List<Path>> controlEdges, Map<String, Double> totalFlowDisease, Map<String, Double> totalFlowControl, Map<String, Map<String, Double>> flowDifference, RJava rJava, String condition, Set<String> genesPaths, String filename, String dir, List<String> Rscripts) throws IOException {
        LinkedHashSet<String> controlPaths = new LinkedHashSet<String>();
        LinkedHashSet<String> diseasePaths = new LinkedHashSet<String>();
        for (Edge e : diseaseEdges.keySet()) {
            ArrayList auxDisease = new ArrayList(diseaseEdges.get(e));
            ArrayList auxControl = new ArrayList(controlEdges.get(e));
            for (Path p1 : auxDisease) {
                diseasePaths.add(NetDecoderUtils.convertPath2String(p1.getPath(), true));
            }
            for (Path p1 : auxControl) {
                controlPaths.add(NetDecoderUtils.convertPath2String(p1.getPath(), true));
            }
        }
        List<Path> diseaseSpecPaths = NetDecoderUtils.getPhenotypeSpecificPaths(new ArrayList<String>(diseasePaths), new ArrayList<String>(controlPaths));
        List<Path> controlSpecPaths = NetDecoderUtils.getPhenotypeSpecificPaths(new ArrayList<String>(controlPaths), new ArrayList<String>(diseasePaths));
        Map<String, Node> controlNetwork = NetDecoderUtils.createNetworkFromPaths(new ArrayList<String>(controlPaths));
        Map<String, Node> diseaseNetwork = NetDecoderUtils.createNetworkFromPaths(new ArrayList<String>(diseasePaths));
        Map<String, Double> differences_disease = NetDecoderUtils.getFlowDifference(flowDifference, diseaseNetwork.keySet());
        Map<String, Double> differences_control = NetDecoderUtils.getFlowDifference(flowDifference, controlNetwork.keySet());
        Map<String, Double> total_disease = NetDecoderUtils.getTotalFlowInProteins(totalFlowDisease, diseaseNetwork.keySet());
        Map<String, Double> total_control = NetDecoderUtils.getTotalFlowInProteins(totalFlowControl, controlNetwork.keySet());
        NetDecoderUtils.saveFlows(total_control, filename + "_EDGE_CENTERED_SUBNET_totalFlow_Control.txt");
        NetDecoderUtils.saveFlows(total_disease, filename + "_EDGE_CENTERED_SUBNET_totalFlow_Disease.txt");
        NetDecoderUtils.saveFlows(differences_control, filename + "_EDGE_CENTERED_SUBNET_flowDifference_Control.txt");
        NetDecoderUtils.saveFlows(differences_disease, filename + "_EDGE_CENTERED_SUBNET_flowDifference_Disease.txt");
        NetDecoderUtils.saveGeneList(controlNetwork, filename + "_EDGE_CENTERED_SUBNET_GENES_Control.txt");
        NetDecoderUtils.saveGeneList(diseaseNetwork, filename + "_EDGE_CENTERED_SUBNET_GENES_Disease.txt");
        new NetworkFlow().saveSubNet(controlNetwork, filename + "_EDGE_CENTERED_SUBNET_Control.txt");
        new NetworkFlow().saveSubNet(diseaseNetwork, filename + "_EDGE_CENTERED_SUBNET_Disease.txt");
        NetDecoderUtils.savePaths(NetDecoderUtils.convertString2Paths(new ArrayList<String>(diseasePaths)), filename + "_EDGE_CENTERED_SUBNET_Disease_paths.txt");
        NetDecoderUtils.savePaths(NetDecoderUtils.convertString2Paths(new ArrayList<String>(controlPaths)), filename + "_EDGE_CENTERED_SUBNET_Control_paths.txt");
        Map<String, Node> controlDFN = NetDecoderUtils.createNetworkFromPaths(NetDecoderUtils.convertPaths2String(controlSpecPaths));
        Map<String, Node> diseaseDFN = NetDecoderUtils.createNetworkFromPaths(NetDecoderUtils.convertPaths2String(diseaseSpecPaths));
        Map<String, Double> controlDFNdiff = NetDecoderUtils.getFlowDifference(flowDifference, controlDFN.keySet());
        Map<String, Double> diseaseDFNdiff = NetDecoderUtils.getFlowDifference(flowDifference, diseaseDFN.keySet());
        Map<String, Double> controlDFNtotal = NetDecoderUtils.getTotalFlowInProteins(totalFlowControl, controlDFN.keySet());
        Map<String, Double> diseaseDFNtotal = NetDecoderUtils.getTotalFlowInProteins(totalFlowDisease, diseaseDFN.keySet());
        NetDecoderUtils.saveFlows(controlDFNtotal, filename + "_DFN_totalFlow_Control.txt");
        NetDecoderUtils.saveFlows(diseaseDFNtotal, filename + "_DFN_totalFlow_Disease.txt");
        NetDecoderUtils.saveFlows(controlDFNdiff, filename + "_DFN_flowDifference_Control.txt");
        NetDecoderUtils.saveFlows(diseaseDFNdiff, filename + "_DFN_flowDifference_Disease.txt");
        NetDecoderUtils.saveGeneList(controlDFN, filename + "_DFN_GENES_Control.txt");
        NetDecoderUtils.saveGeneList(diseaseDFN, filename + "_DFN_GENES_Disease.txt");
        new NetworkFlow().saveSubNet(controlDFN, filename + "_DFN_Control.txt");
        new NetworkFlow().saveSubNet(diseaseDFN, filename + "_DFN_Disease.txt");
        NetDecoderUtils.savePaths(controlSpecPaths, filename + "_DFN_Control_paths.txt");
        NetDecoderUtils.savePaths(diseaseSpecPaths, filename + "_DFN_Disease_paths.txt");
        String venn1 = rJava.createVennGenesPathsScript(dir, filename + "_EDGE_CENTERED_SUBNET_GENES_Control", filename + "_EDGE_CENTERED_SUBNET_GENES_Disease", condition, "gene", "gene_overlap");
        String venn2 = rJava.createVennGenesPathsScript(dir, filename + "_EDGE_CENTERED_SUBNET_Control_paths", filename + "_EDGE_CENTERED_SUBNET_Disease_paths", condition, "path", "path_overlap");
        String venn3 = rJava.createVennEdgesScript(dir, filename + "_EDGE_CENTERED_SUBNET_Control", filename + "_EDGE_CENTERED_SUBNET_Disease", condition, "edge_overlap");
        String venn4 = rJava.createVennGenesPathsScript(dir, filename + "_DFN_GENES_Control", filename + "_DFN_GENES_Disease", condition, "gene", "DFN_gene_overlap");
        String venn5 = rJava.createVennGenesPathsScript(dir, filename + "_DFN_Control_paths", filename + "_DFN_Disease_paths", condition, "path", "DFN_path_overlap");
        String venn6 = rJava.createVennEdgesScript(dir, filename + "_DFN_Control", filename + "_DFN_Disease", condition, "DFN_edge_overlap");
        Rscripts.add(venn1);
        Rscripts.add(venn2);
        Rscripts.add(venn3);
        Rscripts.add(venn4);
        Rscripts.add(venn5);
        Rscripts.add(venn6);
        String gml1 = rJava.createScriptExportGML(filename + "_EDGE_CENTERED_SUBNET_Control", filename + "_EDGE_CENTERED_SUBNET_totalFlow_Control", filename + "_EDGE_CENTERED_SUBNET_flowDifference_Control");
        String gml2 = rJava.createScriptExportGML(filename + "_EDGE_CENTERED_SUBNET_Disease", filename + "_EDGE_CENTERED_SUBNET_totalFlow_Disease", filename + "_EDGE_CENTERED_SUBNET_flowDifference_Disease");
        String gml3 = rJava.createScriptExportGML(filename + "_DFN_Control", filename + "_DFN_totalFlow_Control", filename + "_DFN_flowDifference_Control");
        String gml4 = rJava.createScriptExportGML(filename + "_DFN_Disease", filename + "_DFN_totalFlow_Disease", filename + "_DFN_flowDifference_Disease");
        Rscripts.add(gml1);
        Rscripts.add(gml2);
        Rscripts.add(gml3);
        Rscripts.add(gml4);
        if (genesPaths != null) {
            System.out.println("Saving paths associated to a given gene list...");
            try {
                ArrayList<String> tmpDisease = new ArrayList<String>(NetDecoderUtils.convertPaths2String(diseaseSpecPaths));
                ArrayList<String> tmpControl = new ArrayList<String>(NetDecoderUtils.convertPaths2String(controlSpecPaths));
                List<String> adjDisease = NetDecoderUtils.getPathsFromGenes(diseaseDFN, tmpDisease, new ArrayList<String>(genesPaths), rJava, dir, filename + "_Disease");
                List<String> adjControl = NetDecoderUtils.getPathsFromGenes(controlDFN, tmpControl, new ArrayList<String>(genesPaths), rJava, dir, filename + "_Control");
                Rscripts.addAll(adjDisease);
                Rscripts.addAll(adjControl);
            }
            catch (Exception io) {
                System.out.println(io.getMessage());
            }
        }
        NetDecoderUtils.getJaccardIndex(diseaseNetwork, controlNetwork, filename + "_EDGE_CENTERED_SUBNET_Jaccard_" + condition + ".txt");
        String jaccard = rJava.createJaccardMatrixScript(filename + "_EDGE_CENTERED_SUBNET_Jaccard_" + condition);
        Rscripts.add(jaccard);
    }

    public static Map<String, Double> getTotalFlowInProteins(Map<String, Double> totalFlows, Set<String> genes) {
        LinkedHashMap<String, Double> total = new LinkedHashMap<String, Double>();
        for (String gene : genes) {
            total.put(gene, totalFlows.get(gene));
        }
        return total;
    }

    public static Map<String, Double> getFlowDifference(Map<String, Map<String, Double>> totalFlows, Set<String> genes) {
        LinkedHashMap<String, Double> difference = new LinkedHashMap<String, Double>();
        for (String gene : genes) {
            difference.put(gene, totalFlows.get(gene).get("difference"));
        }
        return difference;
    }

    public static List<String> convertPaths2String(List<Path> paths) {
        ArrayList<String> newPaths = new ArrayList<String>();
        for (Path p : paths) {
            newPaths.add(NetDecoderUtils.convertPath2String(p.getPath(), true));
        }
        return newPaths;
    }

    public static double calcFlowFromPaths(List<List<Edge>> paths) {
        double flow = 0.0;
        for (List<Edge> p : paths) {
            flow += NetDecoderUtils.getFlowFromPath(p);
        }
        return flow;
    }

    public static double getFlowFromPath(List<Edge> path) {
        double flow = 0.0;
        for (Edge e : path) {
            if (e.getFrom().getName().equals("s") || e.getTo().getName().equals("t")) continue;
            flow += e.getFlow();
        }
        return flow;
    }

    public static double getPathCost(List<Edge> path) {
        double cost = 0.0;
        for (Edge e : path) {
            if (e.getFrom().getName().equals("s") || e.getTo().getName().equals("t")) continue;
            cost += e.getCost();
        }
        return cost;
    }

    public static double calculateDistance(double[] array1, double[] array2) {
        double sum = 0.0;
        for (int i = 0; i < array1.length; ++i) {
            sum += Math.pow(array1[i] - array2[i], 2.0);
        }
        return Math.sqrt(sum);
    }

    public static double calculateDistance(Map<String, Double> array1, Map<String, Double> array2, String[] arrays) {
        double sum = 0.0;
        for (String array : arrays) {
            sum += Math.pow(array1.get(array) - array2.get(array), 2.0);
        }
        return Math.sqrt(sum);
    }

    public static double calculateDistance(double value1, double value2) {
        return Math.sqrt(Math.pow(value1 - value2, 2.0));
    }

    public static Map<String, Double> averageFlow(Map<String, Map<String, Double>> edgesMatrix, Set<String> edges, String[] arrays) {
        LinkedHashMap<String, Double> meanFlow = new LinkedHashMap<String, Double>();
        for (String edge : edges) {
            double sum = 0.0;
            for (String array : arrays) {
                sum += edgesMatrix.get(edge).get(array).doubleValue();
            }
            double mean = sum / (double)arrays.length;
            meanFlow.put(edge, mean);
        }
        return meanFlow;
    }

    public static List<Double> calcZscore(Map<String, Double> edgeFlows) {
        double mean = NetDecoderUtils.getMean(edgeFlows.values());
        double std = NetDecoderUtils.getStdDev(edgeFlows.values());
        ArrayList<Double> zscore = new ArrayList<Double>();
        for (String array : edgeFlows.keySet()) {
            double tmp = (edgeFlows.get(array) - mean) / std;
            zscore.add(tmp);
        }
        return zscore;
    }

    public static Map<String, Double> calcZscoreEdge(Map<String, Double> edgeFlows) {
        double mean = NetDecoderUtils.getMean(edgeFlows.values());
        double std = NetDecoderUtils.getStdDev(edgeFlows.values());
        LinkedHashMap<String, Double> zscore = new LinkedHashMap<String, Double>();
        for (String edge : edgeFlows.keySet()) {
            double tmp = (edgeFlows.get(edge) - mean) / std;
            zscore.put(edge, tmp);
        }
        return zscore;
    }

    public static double calcMeanZscore(Map<String, Double> edgeFlows, String[] arrays) {
        List<Double> zscore = NetDecoderUtils.calcZscore(edgeFlows);
        double meanZscore = NetDecoderUtils.getMean(zscore);
        return meanZscore;
    }

    public static double getMean(Collection<Double> data) {
        double sum = 0.0;
        for (double d : data) {
            sum += d;
        }
        return sum / (double)data.size();
    }

    public static double getVariance(Collection<Double> data) {
        double mean = NetDecoderUtils.getMean(data);
        double temp = 0.0;
        for (double a : data) {
            temp += (mean - a) * (mean - a);
        }
        return temp / (double)data.size();
    }

    public static double getStdDev(Collection<Double> data) {
        return Math.sqrt(NetDecoderUtils.getVariance(data));
    }

    public Map<String, Map<String, Double>> changeMapping(Map<String, Map<String, Double>> edgesMatrix) {
        LinkedHashMap<String, Map<String, Double>> auxEdgesMatrix = new LinkedHashMap<String, Map<String, Double>>();
        for (String array : edgesMatrix.keySet()) {
            for (String edge : edgesMatrix.get(array).keySet()) {
                if (!auxEdgesMatrix.containsKey(edge)) {
                    LinkedHashMap<String, Double> aux2 = new LinkedHashMap<String, Double>();
                    aux2.put(array, edgesMatrix.get(array).get(edge));
                    auxEdgesMatrix.put(edge, aux2);
                    continue;
                }
                ((Map)auxEdgesMatrix.get(edge)).put(array, edgesMatrix.get(array).get(edge));
            }
        }
        return auxEdgesMatrix;
    }

    public static void saveAllPaths(String[] arrays, Map<String, Map<String, String>> uniprot2symbol, String dir) {
        NetworkFlow net = new NetworkFlow();
        Map paths = null;
        for (int array = 0; array < arrays.length; ++array) {
            ArrayList<String> pathsFlow = new ArrayList<String>();
            String experiment = arrays[array];
            String fileSubnetPaths = "subnetPaths_" + experiment + ".ser";
            paths = Serialization.deserialize(dir + fileSubnetPaths, Map.class);
            for (Integer path : paths.keySet()) {
                String pathFlowAsString = NetDecoderUtils.convertPath2String((List)paths.get(path), true);
                pathsFlow.add(pathFlowAsString);
            }
            Serialization.serialize(pathsFlow, dir + "subnetPaths_" + experiment + "_compact.ser");
        }
    }

    public static Map<String, Node> createMotifTargets(String gene, List<Edge> edges) {
        LinkedHashMap<String, Node> subnet = new LinkedHashMap<String, Node>();
        NetworkFlow net = new NetworkFlow();
        for (Edge e : edges) {
            Node from = new Node(e.getFrom().getName());
            Node to = new Node(e.getTo().getName());
            if (from.getName().equals("s") || to.getName().equals("t") || !to.getName().equals(gene)) continue;
            from.setSymbol(from.getName());
            to.setSymbol(to.getName());
            Edge edge = new Edge(from, to);
            edge.setFlow(e.getFlow());
            edge.setSignScore(e.getSignScore());
            if (!net.hasNode(subnet, from)) {
                net.addNode(subnet, from);
            }
            if (!net.hasNode(subnet, to)) {
                net.addNode(subnet, to);
            }
            if (!((Node)subnet.get(from.getName())).getEdges().contains(e)) {
                ((Node)subnet.get(from.getName())).addEdge(e);
            }
            if (((Node)subnet.get(to.getName())).getEdges().contains(e)) continue;
            ((Node)subnet.get(to.getName())).addEdge(e);
        }
        return subnet;
    }

    public static Map<String, Node> createMotifNetworkRouters(String gene, List<Edge> edges) {
        LinkedHashMap<String, Node> subnet = new LinkedHashMap<String, Node>();
        NetworkFlow net = new NetworkFlow();
        for (Edge e : edges) {
            Node from = new Node(e.getFrom().getName());
            Node to = new Node(e.getTo().getName());
            if (from.getName().equals("s") || to.getName().equals("t") || !from.getName().equals(gene)) continue;
            from.setSymbol(from.getName());
            to.setSymbol(to.getName());
            Edge edge = new Edge(from, to);
            edge.setFlow(e.getFlow());
            edge.setSignScore(e.getSignScore());
            if (!net.hasNode(subnet, from)) {
                net.addNode(subnet, from);
            }
            if (!net.hasNode(subnet, to)) {
                net.addNode(subnet, to);
            }
            if (!((Node)subnet.get(from.getName())).getEdges().contains(e)) {
                ((Node)subnet.get(from.getName())).addEdge(e);
            }
            if (((Node)subnet.get(to.getName())).getEdges().contains(e)) continue;
            ((Node)subnet.get(to.getName())).addEdge(e);
        }
        return subnet;
    }

    public static Map<String, Node> createMotifImpactScore(List<Edge> edges) {
        LinkedHashMap<String, Node> subnet = new LinkedHashMap<String, Node>();
        NetworkFlow net = new NetworkFlow();
        for (Edge e : edges) {
            Node from = new Node(e.getFrom().getName());
            Node to = new Node(e.getTo().getName());
            if (from.getName().equals("s") || to.getName().equals("t")) continue;
            from.setSymbol(from.getName());
            to.setSymbol(to.getName());
            Edge edge = new Edge(from, to);
            edge.setFlow(e.getFlow());
            edge.setSignScore(e.getSignScore());
            if (!net.hasNode(subnet, from)) {
                net.addNode(subnet, from);
            }
            if (!net.hasNode(subnet, to)) {
                net.addNode(subnet, to);
            }
            if (!((Node)subnet.get(from.getName())).getEdges().contains(e)) {
                ((Node)subnet.get(from.getName())).addEdge(e);
            }
            if (((Node)subnet.get(to.getName())).getEdges().contains(e)) continue;
            ((Node)subnet.get(to.getName())).addEdge(e);
        }
        return subnet;
    }

    public static Map<String, Node> createNetworkFromPaths(List<String> paths) {
        LinkedHashMap<String, Node> subnet = new LinkedHashMap<String, Node>();
        NetworkFlow net = new NetworkFlow();
        for (String auxPath : paths) {
            Path path = NetDecoderUtils.convertString2Path(auxPath);
            for (int i = 0; i < path.getPath().size(); ++i) {
                Edge auxE = path.getPath().get(i);
                Node from = new Node(auxE.getFrom().getName());
                from.setSymbol(auxE.getFrom().getSymbol());
                Node to = new Node(auxE.getTo().getName());
                to.setSymbol(auxE.getTo().getSymbol());
                if (!net.hasNode(subnet, from)) {
                    net.addNode(subnet, from);
                }
                if (!net.hasNode(subnet, to)) {
                    net.addNode(subnet, to);
                }
                Edge e = new Edge(from, to);
                e.setFlow(auxE.getFlow());
                e.setSignScore(auxE.getSignScore());
                if (!((Node)subnet.get(from.getName())).getEdges().contains(e)) {
                    ((Node)subnet.get(from.getName())).addEdge(e);
                }
                if (((Node)subnet.get(to.getName())).getEdges().contains(e)) continue;
                ((Node)subnet.get(to.getName())).addEdge(e);
            }
        }
        return subnet;
    }

    public static Map<String, Node> createNetworkFromPaths2Plot(List<String> paths) {
        LinkedHashMap<String, Node> subnet = new LinkedHashMap<String, Node>();
        NetworkFlow net = new NetworkFlow();
        for (String auxPath : paths) {
            Path path = NetDecoderUtils.convertString2Path(auxPath);
            for (int i = path.getPath().size() - 1; i >= 0; --i) {
                Edge auxE = path.getPath().get(i);
                if (i > 0) {
                    Edge nextEdge = path.getPath().get(i - 1);
                    if (!auxE.getTo().getName().equals(nextEdge.getFrom().getName())) {
                        Edge tmpEdge = new Edge(nextEdge.getTo(), nextEdge.getFrom());
                        tmpEdge.setFlow(nextEdge.getFlow());
                        tmpEdge.setSignScore(nextEdge.getSignScore());
                        path.getPath().set(i - 1, tmpEdge);
                    }
                }
                Node from = new Node(auxE.getFrom().getName());
                from.setSymbol(auxE.getFrom().getSymbol());
                Node to = new Node(auxE.getTo().getName());
                to.setSymbol(auxE.getTo().getSymbol());
                if (!net.hasNode(subnet, from)) {
                    net.addNode(subnet, from);
                }
                if (!net.hasNode(subnet, to)) {
                    net.addNode(subnet, to);
                }
                Edge e = new Edge(from, to);
                e.setFlow(auxE.getFlow());
                e.setSignScore(auxE.getSignScore());
                if (!((Node)subnet.get(from.getName())).getEdges().contains(e)) {
                    ((Node)subnet.get(from.getName())).addEdge(e);
                }
                if (((Node)subnet.get(to.getName())).getEdges().contains(e)) continue;
                ((Node)subnet.get(to.getName())).addEdge(e);
            }
        }
        return subnet;
    }

    public static List<Double> splitEdgesFlow(String path) {
        String[] edges = path.split("\\,");
        ArrayList<Double> flows = new ArrayList<Double>();
        for (int i = 0; i < edges.length; ++i) {
            Double flow = Double.valueOf(edges[i].split("\\->")[2]);
            flows.add(flow);
        }
        return flows;
    }

    public static List<Double> splitEdgesCost(String path) {
        String[] edges = path.split("\\,");
        ArrayList<Double> flows = new ArrayList<Double>();
        for (int i = 0; i < edges.length; ++i) {
            Double flow = Double.valueOf(edges[i].split("\\->")[3]);
            flows.add(flow);
        }
        return flows;
    }

    public static String convertPath2String(List<Edge> path, boolean flow) {
        String s = "";
        for (int i = 0; i < path.size(); ++i) {
            Edge e = path.get(i);
            String s1 = e.getFrom().getName();
            String s2 = e.getTo().getName();
            if (flow) {
                if (i == path.size() - 1) {
                    s = s + s1 + "->" + s2 + "->" + e.getFlow() + "->" + e.getSignScore() + "->" + e.getCost();
                    continue;
                }
                s = s + s1 + "->" + s2 + "->" + e.getFlow() + "->" + e.getSignScore() + "->" + e.getCost() + ",";
                continue;
            }
            s = i == path.size() - 1 ? s + s1 + "->" + s2 : s + s1 + "->" + s2 + ",";
        }
        return s;
    }

    public static Edge getEdge(Map<String, Node> network, Edge e) {
        if (network.get(e.getFrom().getName()) == null) {
            return null;
        }
        for (Edge es : network.get(e.getFrom().getName()).getEdges()) {
            if (!es.getFrom().getName().equals(e.getFrom().getName()) || !es.getTo().getName().equals(e.getTo().getName())) continue;
            return es;
        }
        return null;
    }

    public static String edge2String(Edge edge) {
        String s1 = edge.getFrom().getSymbol();
        String s2 = edge.getTo().getSymbol();
        return s1 + "->" + s2;
    }

    public static String edge2String2(Edge edge) {
        String s1 = edge.getFrom().getName();
        String s2 = edge.getTo().getName();
        return s1 + "->" + s2;
    }

    public static void saveAdjMatrix(Map<Node, Map<Node, Integer>> adjMatrix, String file) throws IOException {
        File f = new File(file);
        if (!f.exists()) {
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        boolean i = false;
        bw.write("gene");
        for (Node gene : adjMatrix.keySet()) {
            Map<Node, Integer> netflow = adjMatrix.get(gene);
            if (!i) {
                for (Node protein : netflow.keySet()) {
                    String auxSymbol = protein.getSymbol().split("\\/")[0];
                    String symbol = auxSymbol.replace("-", "_");
                    bw.write("\t" + symbol);
                }
                bw.newLine();
                i = true;
            }
            String auxSymbol = gene.getSymbol().split("\\/")[0];
            String symbol = auxSymbol.replace("-", "_");
            bw.write(symbol);
            for (Node protein : netflow.keySet()) {
                bw.write("\t" + netflow.get(protein));
            }
            bw.newLine();
        }
        bw.close();
    }

    public static void saveFlows(Map<String, Double> differences, String file) throws IOException {
        try {
            File f = new File(file);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("gene\tflows");
            bw.newLine();
            for (String gene : differences.keySet()) {
                bw.write(gene + "\t" + differences.get(gene));
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            throw new IOException("Error creating or writing " + file, e);
        }
    }

    public static void saveGeneList(Map<String, Node> network, String file) throws IOException {
        try {
            File f = new File(file);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("gene");
            bw.newLine();
            for (String gene : network.keySet()) {
                String symbols = network.get(gene).getSymbol();
                String symbol = symbols.split("\\/")[0];
                bw.write(symbol);
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            throw new IOException("Error creating or writing " + file, e);
        }
    }

    public static void saveData(Map<String, Map<String, Double>> data, String file) {
        try {
            File f = new File(file);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.newLine();
            boolean column = false;
            for (String c : data.keySet()) {
                if (!column) {
                    for (String g : data.get(c).keySet()) {
                        bw.write("\t" + g);
                    }
                    column = true;
                    bw.newLine();
                }
                bw.write(c);
                for (String g : data.get(c).keySet()) {
                    bw.write("\t" + data.get(c).get(g));
                }
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void saveJaccard(Map<String, Map<String, Double>> similarityMatrix, String file) {
        try {
            File f = new File(file);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileWriter fw = new FileWriter(f.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.newLine();
            boolean column = false;
            for (String c : similarityMatrix.keySet()) {
                if (!column) {
                    for (String g : similarityMatrix.get(c).keySet()) {
                        bw.write("\t" + g);
                    }
                    column = true;
                    bw.newLine();
                }
                bw.write(c);
                for (String g : similarityMatrix.get(c).keySet()) {
                    bw.write("\t" + similarityMatrix.get(c).get(g));
                }
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

