/*
 * Decompiled with CFR 0.152.
 */
package netdecoder;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import netdecoder.Edge;
import netdecoder.InputOutput;
import netdecoder.NetDecoderUtils;
import netdecoder.NetworkFlow;
import netdecoder.Node;
import netdecoder.OntologyUtils;
import netdecoder.Path;
import netdecoder.RJava;
import netdecoder.Serialization;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class NetDecoder {
    private CommandLine cmd = null;
    private Options options = null;
    private String file;
    private String geneSymbol;
    private String ontologyFile;

    public boolean checkArgs(String[] args) {
        try {
            this.options = new Options();
            this.options.addOption("PPI", true, "PPI network");
            this.options.addOption("HGNC", true, "mappings to official gene symbols");
            this.options.addOption("SYMBOL", true, "mappings between protein ids, gene symbols and gene ontologies");
            this.options.addOption("GO", true, "The Gene Ontology");
            this.options.addOption("gen", false, "generate patient-specific networks");
            this.options.addOption("randomizations", true, "num of randomizations to perform");
            this.options.addOption("comp", false, "generate composite network by integrating patient-specific networks");
            this.options.addOption("e", true, "gene expression matrix");
            this.options.addOption("s", true, "table contaning sample annotation");
            this.options.addOption("d", true, "type of network to generate, e.g, control or ERnegative");
            this.options.addOption("control", true, "control annotation from the sample table to select control arrays");
            this.options.addOption("condition", true, "disease annotation from the sample table to select control arrays");
            this.options.addOption("g", true, "gene list to be used as sources");
            this.options.addOption("i", true, "file containing irrelevant Gene Ontologies");
            this.options.addOption("out", true, "output folder to save patient-specific networks");
            this.options.addOption("in", true, "folder containig patient-specific networks");
            this.options.addOption("f", true, "filename");
            this.options.addOption("nc", true, "network control");
            this.options.addOption("ncp", true, "network control paths");
            this.options.addOption("nd", true, "network disease");
            this.options.addOption("ndp", true, "network disease paths");
            this.options.addOption("lfm", true, "load filtered matrix of key interactions");
            this.options.addOption("H", false, "Hub analysis");
            this.options.addOption("S", false, "Evaluate the significance of predicted key edges");
            this.options.addOption("E", false, "Edge analysis");
            this.options.addOption("corThreshold", true, "correlation threshold for key edges");
            this.options.addOption("ratioThreshold", true, "ratio threshold for key edges");
            this.options.addOption("ratioSink", true, "ratio to select sinks with flow differences");
            this.options.addOption("ratioHidden", true, "ratio to select hidden proteins with flow differences");
            this.options.addOption("top", true, "top sinks or hidden proteins");
            this.options.addOption("overlap", false, "Remove overlap control and disese edges");
            this.options.addOption("includeKeyEdges", false, "Prioritize paths including key edges in addition to include hidden and sinks with highest flow differences");
            this.options.addOption("P", false, "Path analysis");
            this.options.addOption("PD", false, "Path analysis with DEGs");
            this.options.addOption("thresholdFlow", true, "Threshold for flow");
            this.options.addOption("thresholdDistance1", true, "Threshold for euclidean distance, similarity");
            this.options.addOption("thresholdDistance2", true, "Threshold for euclidean distance, dyssimilarity");
            this.options.addOption("frequency", true, "Use frequency to filter edges");
            this.options.addOption("C", false, "Evaluate context contribution of disease-associated genes");
            this.options.addOption("gwGOscores", true, "load genome-wide GO scores");
            this.options.addOption("geneGOscores", true, "load gene GO scores");
            this.options.addOption("ds", true, "list of disease states");
            this.options.addOption("gGO", false, "calculate GO scores for disease-associated genes");
            this.options.addOption("GRN", true, "Gene regulatory network used to defined a context for disease-associated genes");
            this.options.addOption("GWGO", false, "generate genome-wide GO scores");
            this.options.addOption("sourceGOscores", true, "file containing GO scores generated from source genes defined by the user (top 100, for example)");
            this.options.addOption("UGL", false, "run NetDecoder using a user-defined gene list as sources");
            this.options.addOption("PKS", false, "Predict key source genes");
            this.options.addOption("PKP", false, "Predic key processes");
            this.options.addOption("GN", false, "Evaluate DFNs in different contexts");
            this.options.addOption("DFN", false, "Obtain two differential networks from two networks");
            this.options.addOption("topPATHS", false, "Create subnetworks from top paths in DFNs");
            this.options.addOption("RANDOM", false, "Create composite networks using a randomized PPI");
            this.options.addOption("rPPI", true, "Random PPI");
            this.options.addOption("rr", true, "Indicate if real or random expression is used");
            this.options.addOption("ccs", true, "list of CCS files, space separated");
            this.options.addOption("cCCS", false, "combine Context-Contribution Scores");
            this.options.addOption("hCCS", true, "Threshold to select high CCS > 10");
            this.options.addOption("lCCS", true, "Threshold to select low CCS (< -10)");
            this.options.addOption("variance", true, "Variance to filter CCS (> 50)");
            this.options.addOption("V", false, "Run a validation analysis");
            PosixParser parser = new PosixParser();
            this.cmd = parser.parse(this.options, args);
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
            return false;
        }
    }

    public void runAnalysis() throws Exception, IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        this.file = this.cmd.getOptionValue("PPI");
        this.geneSymbol = this.cmd.getOptionValue("SYMBOL");
        this.ontologyFile = this.cmd.getOptionValue("GO");
        if (this.cmd.hasOption("gen")) {
            this.generatePhenotypeNetworks();
        } else if (this.cmd.hasOption("RANDOM")) {
            this.generateRandomNetworks();
        } else if (this.cmd.hasOption("E")) {
            this.edgeAnalysis();
            System.exit(0);
        } else if (this.cmd.hasOption("S")) {
            this.computePval();
            System.exit(0);
        } else if (this.cmd.hasOption("C")) {
            System.exit(0);
        } else if (this.cmd.hasOption("cCCS")) {
            if (!this.cmd.hasOption("RANDOM")) {
                this.plotIP();
            }
            System.exit(0);
        } else if (this.cmd.hasOption("V")) {
            this.validation();
            System.exit(0);
        }
    }

    public void validation() throws IOException {
    }

    public void computePval() throws Exception {
        String dir = this.cmd.getOptionValue("out");
        String filename = this.cmd.getOptionValue("f");
        String ncp = this.cmd.getOptionValue("nc");
        String ndp = this.cmd.getOptionValue("nd");
        String condition = this.cmd.getOptionValue("condition");
        List controlPaths = Serialization.deserialize(ncp, List.class);
        List diseasePaths = Serialization.deserialize(ndp, List.class);
        List<Path> cPaths = NetDecoderUtils.convertString2Paths(controlPaths);
        List<Path> dPaths = NetDecoderUtils.convertString2Paths(diseasePaths);
        System.out.println(controlPaths.size());
        System.out.println(diseasePaths.size());
        System.out.println(dPaths.size());
        String ref = "RandomNetwork_ERnegative_Sources";
        ArrayList<List<Path>> allRandomPaths = new ArrayList<List<Path>>();
        for (int i = 0; i < 50; ++i) {
            String path_dir = dir + condition + "/random/random_" + i + "/";
            String open = path_dir + ref;
            List randomPathsAux = Serialization.deserialize(open + "_paths.ser", List.class);
            List<Path> randomPaths = NetDecoderUtils.convertString2Paths(randomPathsAux);
            allRandomPaths.add(randomPaths);
        }
        ArrayList<Path> significantPaths = new ArrayList<Path>();
        for (Path path : dPaths) {
            double countHigher = 0.0;
            for (int i = 0; i < 50; ++i) {
                List randomPaths = (List)allRandomPaths.get(i);
                double rPathFlow = 0.0;
                if (randomPaths.contains(path)) {
                    int index = randomPaths.indexOf(path);
                    Path rPath = (Path)randomPaths.get(index);
                    rPathFlow = rPath.getFlow();
                }
                if (!(rPathFlow >= path.getFlow())) continue;
                countHigher += 1.0;
            }
            double pvalueHigher = countHigher / 50.0;
            if (!(pvalueHigher < 0.05)) continue;
            significantPaths.add(path);
            System.out.println(path);
            System.out.println("higher flow: " + pvalueHigher);
            System.out.println("-----------");
        }
        System.out.println("significant paths: " + significantPaths.size() + " of " + dPaths.size());
    }

    public void computePval_TMP_OLD() throws Exception {
        String dir = this.cmd.getOptionValue("out");
        String filename = this.cmd.getOptionValue("f");
        String nc = this.cmd.getOptionValue("nc");
        String nd = this.cmd.getOptionValue("nd");
        String condition = this.cmd.getOptionValue("condition");
        Map controlNetwork = Serialization.deserialize(nc, Map.class);
        Map diseaseNetwork = Serialization.deserialize(nd, Map.class);
        Map<String, Map<String, Double>> flowInNetworks = this.getFlowInNetworks(controlNetwork, diseaseNetwork);
        Map<String, Double> obsFlowDifference = this.computeImpactScore(controlNetwork, diseaseNetwork);
        System.out.println(controlNetwork.size());
        System.out.println(diseaseNetwork.size());
        System.out.println(obsFlowDifference.size());
        String ref = "RandomNetwork_ERnegative_Sources";
        for (String gene : obsFlowDifference.keySet()) {
            System.out.println(gene);
            double countHigher = 0.0;
            double countLower = 0.0;
            double total = 0.0;
            for (int i = 0; i < 50; ++i) {
                String path = dir + condition + "/random/random_" + i + "/";
                String open = path + ref;
                Map randomNetwork = Serialization.deserialize(open + "_subnet.ser", Map.class);
                Map<String, Double> randFlowDifference = this.computeImpactScore(controlNetwork, randomNetwork);
                if (randFlowDifference.containsKey(gene)) {
                    if (randFlowDifference.get(gene) >= obsFlowDifference.get(gene)) {
                        countHigher += 1.0;
                    }
                    if (!(randFlowDifference.get(gene) <= obsFlowDifference.get(gene))) continue;
                    countLower += 1.0;
                    continue;
                }
                System.out.println("it is not a sink in random network...");
            }
            double pvalueHigher = countHigher / 50.0;
            double pvalueLower = countLower / 50.0;
            System.out.println(pvalueHigher);
            System.out.println(pvalueLower);
            System.out.println("-----------");
        }
    }

    public void applyEdgeAnalysis2RandomNetworks() throws Exception {
        String dir = this.cmd.getOptionValue("out");
        String filename = this.cmd.getOptionValue("f");
        String nc = this.cmd.getOptionValue("nc");
        String ncp = this.cmd.getOptionValue("ncp");
        String control = this.cmd.getOptionValue("control");
        String condition = this.cmd.getOptionValue("condition");
        Double corThreshold = Double.valueOf(this.cmd.getOptionValue("corThreshold"));
        Double ratioThreshold = Double.valueOf(this.cmd.getOptionValue("ratioThreshold"));
        Double ratioSink = Double.valueOf(this.cmd.getOptionValue("ratioSink"));
        Double ratioHidden = Double.valueOf(this.cmd.getOptionValue("ratioHidden"));
        Integer top = Integer.valueOf(this.cmd.getOptionValue("top"));
        RJava rJava = new RJava();
        Map controlNetwork = Serialization.deserialize(nc, Map.class);
        String ref = "RandomNetwork_ERnegative_Sources";
        for (int i = 0; i < 50; ++i) {
            String path = dir + condition + "/random/random_" + i + "/";
            String open = path + ref;
            System.out.println("Opening file in " + open);
            Map diseaseNetwork = Serialization.deserialize(open + "_subnet.ser", Map.class);
            Map<String, Map<String, Double>> flowInNetworks = this.getFlowInNetworks(controlNetwork, diseaseNetwork);
            Set<Edge> cEdges = this.getAllEdges(controlNetwork);
            Set<Edge> dEdges = this.getAllEdges(diseaseNetwork);
            LinkedHashMap<String, Map<String, Double>> flowMatrix = new LinkedHashMap<String, Map<String, Double>>();
            if (!this.cmd.hasOption("overlap")) {
                dEdges.addAll(cEdges);
            } else {
                dEdges.retainAll(cEdges);
            }
            LinkedHashMap<String, Double> xxControl = new LinkedHashMap<String, Double>();
            LinkedHashMap<String, Double> xxDisease = new LinkedHashMap<String, Double>();
            for (Edge e : dEdges) {
                Edge eControl = NetDecoderUtils.getEdge(controlNetwork, e);
                Edge eDisease = NetDecoderUtils.getEdge(diseaseNetwork, e);
                if (eControl != null && eDisease != null) {
                    xxControl.put(e.toString(), eControl.getFlow());
                    xxDisease.put(e.toString(), eDisease.getFlow());
                    continue;
                }
                if (eControl != null) {
                    xxControl.put(e.toString(), eControl.getFlow());
                    xxDisease.put(e.toString(), 0.0);
                    continue;
                }
                if (eDisease == null) continue;
                xxControl.put(e.toString(), 0.0);
                xxDisease.put(e.toString(), eDisease.getFlow());
            }
            flowMatrix.put(control, xxControl);
            flowMatrix.put(condition, xxDisease);
            Map<String, Map<String, Double>> aux = this.changeMapping(flowMatrix);
            String name = path + filename + "_flowMatrix";
            NetDecoder.saveFlowMatrix(aux, control, condition, name + ".txt");
            rJava.plotBarplot(path, name, condition, corThreshold, ratioThreshold, filename);
        }
        this.countFeatures(dir, filename, condition);
    }

    public void countFeatures(String dir, String filename, String condition) throws Exception {
        String rKeyEdges = dir + condition + "/" + filename + "_keyEdges.txt";
        System.out.println(rKeyEdges);
        Set<Edge> realKeyEdges = NetDecoder.loadKeyEdges(rKeyEdges);
        LinkedHashMap<String, Integer> countKeyEdges = new LinkedHashMap<String, Integer>();
        for (Edge ed : realKeyEdges) {
            countKeyEdges.put(ed.toString(), 0);
        }
        for (int i = 0; i < 50; ++i) {
            String random = "/random/random_" + i;
            String path = dir + condition + random + "/";
            String keyEdgesFile = path + filename + "_keyEdges.txt";
            Set<Edge> keyEdges = NetDecoder.loadKeyEdges(keyEdgesFile);
            for (Edge e : keyEdges) {
                if (!countKeyEdges.containsKey(e.toString())) continue;
                countKeyEdges.put(e.toString(), (Integer)countKeyEdges.get(e.toString()) + 1);
            }
        }
        System.out.println(countKeyEdges);
    }

    public List<Double> getRandomCorrelations(List<Double> correlations) {
        ArrayList<Double> random = new ArrayList<Double>();
        int max = correlations.size();
        int min = 0;
        for (int i = 0; i < correlations.size(); ++i) {
            Random rand = new Random();
            int randomNumber = rand.nextInt(max - min + min);
            random.add(correlations.get(randomNumber));
        }
        return random;
    }

    public void generateRandomNetworks() throws IOException {
        System.out.println("Random networks...");
        String geneListFile = this.cmd.getOptionValue("g");
        String state = this.cmd.getOptionValue("d");
        String filename = this.cmd.getOptionValue("f");
        int numIterations = Integer.valueOf(this.cmd.getOptionValue("randomizations"));
        String dir = this.cmd.getOptionValue("out");
        OntologyUtils utils = new OntologyUtils(this.ontologyFile);
        NetworkFlow net = new NetworkFlow();
        InputOutput io = new InputOutput();
        io.getColumnFromMITABFaster(this.file);
        List<String> TFAnnot = this.setDefaultSinks();
        LinkedHashSet<String> sourceGenes = new LinkedHashSet<String>(NetworkFlow.getGenes(geneListFile));
        Set<String> sinks = net.setUniversalSinksHuman(utils, TFAnnot, this.geneSymbol);
        List<List<Node>> sourcesAndSinks = net.selectSources(sourceGenes, sinks, io.getProteinsA(), io.getProteinsB());
        List<Node> sources = sourcesAndSinks.get(0);
        List<Node> sinkNodes = sourcesAndSinks.get(1);
        for (int i = 0; i < numIterations; ++i) {
            String path2create = dir + state + "/random_" + i + "/";
            new File(path2create).mkdirs();
            System.out.println("saving data into: " + path2create);
            List<Double> correlations = this.getRandomCorrelations(io.getCorrelations());
            List<Double> signCors = io.getSignCors();
            LinkedHashMap<Integer, Map<String, Edge>> allPathsNet = new LinkedHashMap<Integer, Map<String, Edge>>();
            LinkedHashSet<String> sinkGOSubnet = new LinkedHashSet<String>();
            LinkedHashMap<String, Node> network = new LinkedHashMap<String, Node>();
            net.createNetwork(sources, sinkNodes, network, io.getProteinsA(), io.getProteinsB(), correlations, signCors);
            net.mappingNameToId(network);
            net.setGOHuman(network, utils, this.geneSymbol);
            net.compute(network, allPathsNet, utils, sinkGOSubnet);
            LinkedHashMap<String, Node> subnet = new LinkedHashMap<String, Node>();
            Map<Integer, List<Edge>> pathsSubnet = net.buildSubnet(network, subnet, allPathsNet);
            ArrayList<String> pathsFlow = new ArrayList<String>();
            for (Integer path : pathsSubnet.keySet()) {
                String pathFlowAsString = NetDecoderUtils.convertPath2String(pathsSubnet.get(path), true);
                pathsFlow.add(pathFlowAsString);
            }
            String subnetName = filename + "_subnet.ser";
            String pathsName = filename + "_paths.ser";
            Serialization.serialize(subnet, path2create + subnetName);
            Serialization.serialize(pathsFlow, path2create + pathsName);
            Map<String, Double> GOscoreW = NetworkFlow.countGOWeighted(subnet);
            NetworkFlow.saveGOscoresW(GOscoreW, state, utils, path2create + filename + ".txt");
        }
    }

    public void generatePhenotypeNetworks() throws IOException {
        System.out.println("Phenotype-specific networks...");
        String geneListFile = this.cmd.getOptionValue("g");
        String state = this.cmd.getOptionValue("d");
        String filename = this.cmd.getOptionValue("f");
        String dir = this.cmd.getOptionValue("out");
        OntologyUtils utils = new OntologyUtils(this.ontologyFile);
        NetworkFlow net = new NetworkFlow();
        InputOutput io = new InputOutput();
        io.getColumnFromMITABFaster(this.file);
        List<String> TFAnnot = this.setDefaultSinks();
        LinkedHashSet<String> sourceGenes = new LinkedHashSet<String>(NetworkFlow.getGenes(geneListFile));
        List<Double> correlations = io.getCorrelations();
        List<Double> signCors = io.getSignCors();
        LinkedHashMap<Integer, Map<String, Edge>> allPathsNet = new LinkedHashMap<Integer, Map<String, Edge>>();
        LinkedHashSet<String> sinkGOSubnet = new LinkedHashSet<String>();
        LinkedHashMap<String, Node> network = new LinkedHashMap<String, Node>();
        Set<String> sinks = net.setUniversalSinksHuman(utils, TFAnnot, this.geneSymbol);
        List<List<Node>> sourcesAndSinks = net.selectSources(sourceGenes, sinks, io.getProteinsA(), io.getProteinsB());
        List<Node> sources = sourcesAndSinks.get(0);
        List<Node> sinkNodes = sourcesAndSinks.get(1);
        net.createNetwork(sources, sinkNodes, network, io.getProteinsA(), io.getProteinsB(), correlations, signCors);
        net.mappingNameToId(network);
        net.setGOHuman(network, utils, this.geneSymbol);
        net.compute(network, allPathsNet, utils, sinkGOSubnet);
        LinkedHashMap<String, Node> subnet = new LinkedHashMap<String, Node>();
        Map<Integer, List<Edge>> pathsSubnet = net.buildSubnet(network, subnet, allPathsNet);
        ArrayList<String> pathsFlow = new ArrayList<String>();
        for (Integer path : pathsSubnet.keySet()) {
            String pathFlowAsString = NetDecoderUtils.convertPath2String(pathsSubnet.get(path), true);
            pathsFlow.add(pathFlowAsString);
        }
        String pathsName = filename + "_paths.ser";
        Serialization.serialize(pathsFlow, dir + pathsName);
    }

    public Map<String, Map<String, Double>> changeMapping(Map<String, Map<String, Double>> ccsMap) {
        LinkedHashMap<String, Map<String, Double>> aux = new LinkedHashMap<String, Map<String, Double>>();
        for (String s : ccsMap.keySet()) {
            for (String go : ccsMap.get(s).keySet()) {
                LinkedHashMap<String, Double> aux2 = new LinkedHashMap<String, Double>();
                aux2.put(s, ccsMap.get(s).get(go));
                if (!aux.containsKey(go)) {
                    aux.put(go, aux2);
                    continue;
                }
                ((Map)aux.get(go)).put(s, aux2.get(s));
            }
        }
        return aux;
    }

    public void plotIP() throws IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        String[] ccs = this.cmd.getOptionValue("ccs").split("\\ ");
        List<String> diseases = Arrays.asList(this.cmd.getOptionValue("ds").split("\\ "));
        String filename = this.cmd.getOptionValue("f");
        String dir = this.cmd.getOptionValue("out");
        RJava rJava = new RJava();
        if (diseases.size() == 2) {
            rJava.createScritpHeatmap_CCS(dir, ccs[0], ccs[1], filename, diseases.get(0), diseases.get(1));
        } else {
            rJava.plotHeatmap_CCS_2(dir, ccs[0], ccs[1], ccs[2], filename, diseases.get(0), diseases.get(1), diseases.get(2));
        }
    }

    public static void saveCCSMatrix(Map<String, Map<String, Double>> ccsMatrix, String file) throws IOException {
        File f = new File(file);
        if (!f.exists()) {
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        boolean i = false;
        bw.write("gene");
        for (String gene : ccsMatrix.keySet()) {
            Map<String, Double> ccs = ccsMatrix.get(gene);
            if (!i) {
                for (String matrix : ccs.keySet()) {
                    bw.write("\t" + matrix);
                }
                bw.newLine();
                i = true;
            }
            bw.write(gene);
            for (String matrix : ccs.keySet()) {
                bw.write("\t" + ccs.get(matrix));
            }
            bw.newLine();
        }
        bw.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Double> loadCCS(String file) throws IOException {
        LinkedHashMap<String, Double> ccs = new LinkedHashMap<String, Double>();
        try (BufferedReader in = null;){
            String line;
            in = new BufferedReader(new FileReader(file));
            String firstLine = in.readLine();
            while ((line = in.readLine()) != null) {
                String[] columns = line.split("\t");
                String gene = columns[1];
                Double score = Double.valueOf(columns[2]);
                ccs.put(gene, score);
            }
            LinkedHashMap<String, Double> linkedHashMap = ccs;
            return linkedHashMap;
        }
    }

    public Set<Edge> getAllEdges(Map<String, Node> network) {
        LinkedHashSet<Edge> edges = new LinkedHashSet<Edge>();
        for (String p : network.keySet()) {
            Node protein = network.get(p);
            for (Edge edge : protein.getEdges()) {
                if (edge.getFrom().getName().equals("s") || edge.getTo().getName().equals("t")) continue;
                edges.add(edge);
            }
        }
        return edges;
    }

    public static void saveFlowMatrix(Map<String, Map<String, Double>> flowMatrix, String control, String disease, String file) throws IOException {
        File f = new File(file);
        if (!f.exists()) {
            f.createNewFile();
        }
        FileWriter fw = new FileWriter(f.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write("edge\t" + control + "\t" + disease);
        bw.newLine();
        for (String edge : flowMatrix.keySet()) {
            bw.write(edge);
            Map<String, Double> states = flowMatrix.get(edge);
            for (String state : states.keySet()) {
                bw.write("\t" + states.get(state));
            }
            bw.newLine();
        }
        bw.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Edge> loadKeyEdges(String file) throws IOException {
        LinkedHashSet<Edge> keyEdges = new LinkedHashSet<Edge>();
        int edgesColumn = 0;
        try (BufferedReader in = null;){
            String line;
            in = new BufferedReader(new FileReader(file));
            in.readLine();
            while ((line = in.readLine()) != null) {
                String[] columns = line.split("\t");
                String[] xx = columns[edgesColumn].split("\\->");
                Edge edge = new Edge(new Node(xx[0]), new Node(xx[1]));
                keyEdges.add(edge);
            }
            LinkedHashSet<Edge> linkedHashSet = keyEdges;
            return linkedHashSet;
        }
    }

    public Map<String, Double> computeImpactScore(Map<String, Node> controlNetwork, Map<String, Node> diseaseNetwork) {
        Map<String, Map<String, Double>> flowInNetworks = this.getFlowInNetworks(controlNetwork, diseaseNetwork);
        LinkedHashMap<String, Double> scores = new LinkedHashMap<String, Double>();
        Map<String, Double> sources = NetDecoderUtils.getSources(diseaseNetwork);
        for (String gene : flowInNetworks.keySet()) {
            if (sources.containsKey(gene) || gene.equals("s") || gene.equals("t") || !controlNetwork.containsKey(gene) || !diseaseNetwork.containsKey(gene)) continue;
            double numRI = this.rewiredInteractions(gene, controlNetwork, diseaseNetwork);
            int numCC = this.correlationChange(gene, controlNetwork, diseaseNetwork);
            double score = flowInNetworks.get(gene).get("difference") * numRI * (double)numCC;
            scores.put(gene, score);
        }
        Map sortedScores = NetworkFlow.sortByValues(scores);
        ArrayList aux = new ArrayList(sortedScores.keySet());
        List topGenes_down = aux.subList(0, 20);
        List topGenes_up = aux.subList(aux.size() - 20, aux.size());
        ArrayList topGenes = new ArrayList(topGenes_down);
        topGenes.addAll(topGenes_up);
        LinkedHashMap<String, Double> topGenesScores = new LinkedHashMap<String, Double>();
        for (String g : topGenes) {
            if ((Double)sortedScores.get(g) > 0.0) {
                topGenesScores.put(g, Math.log10((Double)sortedScores.get(g)));
                continue;
            }
            double tmp = -Math.log10(Math.abs((Double)sortedScores.get(g)));
            topGenesScores.put(g, tmp);
        }
        return topGenesScores;
    }

    public Map<String, Double> getEdgeFlow(Map<String, Node> network) {
        LinkedHashMap<String, Double> edgeFlows = new LinkedHashMap<String, Double>();
        Set<Edge> edges = this.getAllEdges(network);
        for (Edge e : edges) {
            edgeFlows.put(e.toString(), e.getFlow());
        }
        return edgeFlows;
    }

    public void impactScore(String path2create) throws IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        String dir = this.cmd.getOptionValue("out");
        String filename = this.cmd.getOptionValue("f");
        String control = this.cmd.getOptionValue("control");
        String condition = this.cmd.getOptionValue("condition");
        String ncp = this.cmd.getOptionValue("ncp");
        String ndp = this.cmd.getOptionValue("ndp");
        RJava rJava = new RJava();
        List controlNetworkPaths = Serialization.deserialize(ncp, List.class);
        List diseaseNetworkPaths = Serialization.deserialize(ndp, List.class);
        Map<String, Node> controlNetwork = NetDecoderUtils.createNetworkFromPaths(controlNetworkPaths);
        Map<String, Node> diseaseNetwork = NetDecoderUtils.createNetworkFromPaths(diseaseNetworkPaths);
        Map<String, Double> topGenesScores = this.computeImpactScore(controlNetwork, diseaseNetwork);
        Map<String, Map<String, Double>> flowDifference = this.getFlowInNetworks(controlNetwork, diseaseNetwork);
        Map<String, Double> totalFlowsDisease = NetDecoderUtils.getTotalFlow(diseaseNetwork);
        Map<String, Double> totalFlowsControl = NetDecoderUtils.getTotalFlow(controlNetwork);
        ArrayList<String> Rscripts = new ArrayList<String>();
        for (String gene : topGenesScores.keySet()) {
            ArrayList<Edge> controlEdges = controlNetwork.get(gene).getEdges();
            ArrayList<Edge> diseaseEdges = diseaseNetwork.get(gene).getEdges();
            Map<String, Node> cNet = NetDecoderUtils.createMotifImpactScore(controlEdges);
            Map<String, Node> dNet = NetDecoderUtils.createMotifImpactScore(diseaseEdges);
            new NetworkFlow().saveSubNet(cNet, path2create + filename + "_" + gene + "_IP_Control.txt");
            new NetworkFlow().saveSubNet(dNet, path2create + filename + "_" + gene + "_IP_Disease.txt");
            Map<String, Double> controlDiff = NetDecoderUtils.getFlowDifference(flowDifference, cNet.keySet());
            Map<String, Double> diseaseDiff = NetDecoderUtils.getFlowDifference(flowDifference, dNet.keySet());
            Map<String, Double> controlTotal = NetDecoderUtils.getTotalFlowInProteins(totalFlowsControl, cNet.keySet());
            Map<String, Double> diseaseTotal = NetDecoderUtils.getTotalFlowInProteins(totalFlowsDisease, dNet.keySet());
            Map<String, Double> controlEdgesFlow = this.getEdgeFlow(cNet);
            Map<String, Double> diseaseEdgesFlow = this.getEdgeFlow(dNet);
            NetDecoderUtils.saveFlows(controlTotal, path2create + filename + "_" + gene + "_IP_totalFlow_Control.txt");
            NetDecoderUtils.saveFlows(diseaseTotal, path2create + filename + "_" + gene + "_IP_totalFlow_Disease.txt");
            NetDecoderUtils.saveFlows(controlDiff, path2create + filename + "_" + gene + "_IP_flowDifference_Control.txt");
            NetDecoderUtils.saveFlows(diseaseDiff, path2create + filename + "_" + gene + "_IP_flowDifference_Disease.txt");
            NetDecoderUtils.saveFlows(controlEdgesFlow, path2create + filename + "_" + gene + "_IP_edge_flows_Control.txt");
            NetDecoderUtils.saveFlows(diseaseEdgesFlow, path2create + filename + "_" + gene + "_IP_edge_flows_Disease.txt");
            String gmlControl = rJava.createScriptExportGML2(path2create + filename + "_" + gene + "_IP_Control", path2create + filename + "_" + gene + "_IP_totalFlow_Control", path2create + filename + "_" + gene + "_IP_flowDifference_Control");
            String gmlDisease = rJava.createScriptExportGML2(path2create + filename + "_" + gene + "_IP_Disease", path2create + filename + "_" + gene + "_IP_totalFlow_Disease", path2create + filename + "_" + gene + "_IP_flowDifference_Disease");
            String distrControl = rJava.createDistributionScript(path2create + filename + "_" + gene + "_IP_edge_flows_Control", control);
            String distrDisease = rJava.createDistributionScript(path2create + filename + "_" + gene + "_IP_edge_flows_Disease", condition);
            Rscripts.add(gmlControl);
            Rscripts.add(gmlDisease);
            Rscripts.add(distrControl);
            Rscripts.add(distrDisease);
        }
        NetDecoderUtils.saveCCS(topGenesScores, condition, filename + "_IMPACT_SCORE_" + condition + ".txt");
        String plotIP = rJava.createScritpHeatmap_CCS_1(dir, filename + "_IMPACT_SCORE_" + condition, condition);
        Rscripts.add(plotIP);
        String scriptName = dir + filename + "_IMPACT_SCORE_combinedScript_" + condition + ".R";
        NetDecoderUtils.combineFiles(Rscripts, scriptName);
        try {
            Runtime.getRuntime().exec("R --slave --no-save CMD BATCH " + scriptName);
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
    }

    public int correlationChange(String gene, Map<String, Node> controlNetwork, Map<String, Node> diseaseNetwork) {
        int count = 1;
        if (controlNetwork.containsKey(gene) && diseaseNetwork.containsKey(gene)) {
            Node geneControl = controlNetwork.get(gene);
            Node geneDisease = diseaseNetwork.get(gene);
            ArrayList<Edge> edgesControl = geneControl.getEdges();
            ArrayList<Edge> edgesDisease = geneDisease.getEdges();
            ArrayList<Edge> aux = new ArrayList<Edge>(edgesControl);
            aux.retainAll(edgesDisease);
            for (Edge e : aux) {
                Double sigDisease;
                int iControl = edgesControl.indexOf(e);
                int iDisease = edgesDisease.indexOf(e);
                Double sigControl = Math.signum(((Edge)edgesControl.get(iControl)).getSignScore());
                if (sigControl.equals(sigDisease = Double.valueOf(Math.signum(((Edge)edgesDisease.get(iDisease)).getSignScore())))) continue;
                ++count;
            }
        }
        return count;
    }

    public double rewiredInteractions(String gene, Map<String, Node> controlNetwork, Map<String, Node> diseaseNetwork) {
        LinkedHashSet<Node> inflowControl = new LinkedHashSet<Node>();
        LinkedHashSet<Node> inflowDisease = new LinkedHashSet<Node>();
        double total = 0.0;
        if (controlNetwork.containsKey(gene) && diseaseNetwork.containsKey(gene)) {
            Node geneControl = controlNetwork.get(gene);
            Node geneDisease = diseaseNetwork.get(gene);
            for (Edge e : geneControl.getEdges()) {
                if (!e.getTo().getName().equals(geneControl.getName())) continue;
                inflowControl.add(e.getFrom());
            }
            for (Edge e : geneDisease.getEdges()) {
                if (!e.getTo().getName().equals(geneDisease.getName())) continue;
                inflowDisease.add(e.getFrom());
            }
            total = inflowControl.size() + inflowDisease.size();
            inflowDisease.removeAll(inflowControl);
        }
        if (inflowDisease.isEmpty()) {
            return 1.0;
        }
        return (double)inflowDisease.size() / total;
    }

    public void edgeAnalysis() throws IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        String dir = this.cmd.getOptionValue("out");
        String filename = this.cmd.getOptionValue("f");
        String ncp = this.cmd.getOptionValue("ncp");
        String ndp = this.cmd.getOptionValue("ndp");
        String control = this.cmd.getOptionValue("control");
        String condition = this.cmd.getOptionValue("condition");
        Double corThreshold = Double.valueOf(this.cmd.getOptionValue("corThreshold"));
        Double ratioThreshold = Double.valueOf(this.cmd.getOptionValue("ratioThreshold"));
        Integer top = Integer.valueOf(this.cmd.getOptionValue("top"));
        RJava rJava = new RJava();
        String geneListFile = this.cmd.getOptionValue("g");
        LinkedHashSet<String> genesPaths = null;
        if (!geneListFile.equals("none")) {
            genesPaths = new LinkedHashSet<String>(NetworkFlow.getGenes(geneListFile));
        }
        List controlNetworkPaths = Serialization.deserialize(ncp, List.class);
        List diseaseNetworkPaths = Serialization.deserialize(ndp, List.class);
        Map<String, Node> controlNetwork = NetDecoderUtils.createNetworkFromPaths(controlNetworkPaths);
        Map<String, Node> diseaseNetwork = NetDecoderUtils.createNetworkFromPaths(diseaseNetworkPaths);
        Map<String, Map<String, Double>> flowInNetworks = this.getFlowInNetworks(controlNetwork, diseaseNetwork);
        Map<String, Double> totalFlowsDisease = NetDecoderUtils.getTotalFlow(diseaseNetwork);
        Map<String, Double> totalFlowsControl = NetDecoderUtils.getTotalFlow(controlNetwork);
        Set<Edge> cEdges = this.getAllEdges(controlNetwork);
        Set<Edge> dEdges = this.getAllEdges(diseaseNetwork);
        LinkedHashMap<String, Map<String, Double>> flowMatrix = new LinkedHashMap<String, Map<String, Double>>();
        if (!this.cmd.hasOption("overlap")) {
            dEdges.addAll(cEdges);
        } else {
            dEdges.retainAll(cEdges);
        }
        LinkedHashMap<String, Double> xxControl = new LinkedHashMap<String, Double>();
        LinkedHashMap<String, Double> xxDisease = new LinkedHashMap<String, Double>();
        for (Edge e : dEdges) {
            Edge eControl = NetDecoderUtils.getEdge(controlNetwork, e);
            Edge eDisease = NetDecoderUtils.getEdge(diseaseNetwork, e);
            if (eControl != null && eDisease != null) {
                xxControl.put(e.toString(), eControl.getFlow());
                xxDisease.put(e.toString(), eDisease.getFlow());
                continue;
            }
            if (eControl != null) {
                xxControl.put(e.toString(), eControl.getFlow());
                xxDisease.put(e.toString(), 0.0);
                continue;
            }
            if (eDisease == null) continue;
            xxControl.put(e.toString(), 0.0);
            xxDisease.put(e.toString(), eDisease.getFlow());
        }
        flowMatrix.put(control, xxControl);
        flowMatrix.put(condition, xxDisease);
        String path2create = dir + condition + "/";
        new File(path2create).mkdirs();
        Map<String, Map<String, Double>> aux = this.changeMapping(flowMatrix);
        String name = path2create + filename + "_flowMatrix";
        NetDecoder.saveFlowMatrix(aux, control, condition, name + ".txt");
        ArrayList<String> Rscripts = new ArrayList<String>();
        String barplot = rJava.createBarplotScript(path2create, name, condition, corThreshold, ratioThreshold, filename);
        try {
            TimeUnit.SECONDS.sleep(5L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        String keyEdgesFile = path2create + filename + "_keyEdges.txt";
        System.out.println(keyEdgesFile);
        Set<Edge> keyEdges = NetDecoder.loadKeyEdges(keyEdgesFile);
        NetDecoderUtils.savePaths(NetDecoderUtils.convertString2Paths(diseaseNetworkPaths), condition + "/" + filename + "_ALL_paths_disease.txt");
        NetDecoderUtils.savePaths(NetDecoderUtils.convertString2Paths(controlNetworkPaths), condition + "/" + filename + "_ALL_paths_control.txt");
        Map<String, Double> controlDFNdiff = NetDecoderUtils.getFlowDifference(flowInNetworks, controlNetwork.keySet());
        Map<String, Double> diseaseDFNdiff = NetDecoderUtils.getFlowDifference(flowInNetworks, diseaseNetwork.keySet());
        Map<String, Double> controlDFNtotal = NetDecoderUtils.getTotalFlowInProteins(totalFlowsControl, controlNetwork.keySet());
        Map<String, Double> diseaseDFNtotal = NetDecoderUtils.getTotalFlowInProteins(totalFlowsDisease, diseaseNetwork.keySet());
        NetDecoderUtils.saveFlows(controlDFNtotal, dir + "/" + condition + "/" + filename + "_FULL_totalFlow_Control.txt");
        NetDecoderUtils.saveFlows(diseaseDFNtotal, condition + "/" + filename + "_FULL_totalFlow_Disease.txt");
        NetDecoderUtils.saveFlows(controlDFNdiff, condition + "/" + filename + "_FULL_flowDifference_Control.txt");
        NetDecoderUtils.saveFlows(diseaseDFNdiff, condition + "/" + filename + "_FULL_flowDifference_Disease.txt");
        NetDecoderUtils.saveGeneList(controlNetwork, condition + "/" + filename + "_FULL_GENES_Control.txt");
        NetDecoderUtils.saveGeneList(diseaseNetwork, condition + "/" + filename + "_FULL_GENES_Disease.txt");
        new NetworkFlow().saveSubNet(controlNetwork, condition + "/" + filename + "_FULL_Control.txt");
        new NetworkFlow().saveSubNet(diseaseNetwork, condition + "/" + filename + "_FULL_Disease.txt");
        String gmlControl = rJava.createScriptExportGML(condition + "/" + filename + "_FULL_Control", condition + "/" + filename + "_FULL_totalFlow_Control", condition + "/" + filename + "_FULL_flowDifference_Control");
        String gmlDisease = rJava.createScriptExportGML(condition + "/" + filename + "_FULL_Disease", condition + "/" + filename + "_FULL_totalFlow_Disease", condition + "/" + filename + "_FULL_flowDifference_Disease");
        Rscripts.add(gmlControl);
        Rscripts.add(gmlDisease);
        Map<Edge, List<Path>> diseaseEdges2Path = NetDecoderUtils.getPathsFromEdges(diseaseNetworkPaths, keyEdges);
        Map<Edge, List<Path>> controlEdges2Path = NetDecoderUtils.getPathsFromEdges(controlNetworkPaths, keyEdges);
        String name_2 = path2create + filename;
        NetDecoderUtils.comparePaths(diseaseEdges2Path, controlEdges2Path, totalFlowsDisease, totalFlowsControl, flowInNetworks, rJava, condition, genesPaths, name_2, path2create, Rscripts);
        System.out.println("Saving key targets");
        Set<String> sinks = this.prioritizeSinks(controlNetwork, diseaseNetwork, condition, top, rJava, name_2, Rscripts);
        System.out.println("Saving Network routers");
        Set<String> hidden = this.prioritizeHiddenProteins(controlNetwork, diseaseNetwork, condition, top, rJava, name_2, Rscripts);
        Set<String> IPgenes = this.computeImpactScore(controlNetwork, diseaseNetwork).keySet();
        this.prioritizePaths(controlNetworkPaths, diseaseNetworkPaths, totalFlowsDisease, flowInNetworks, sinks, hidden, IPgenes, rJava, name_2, Rscripts);
        String scriptName = filename + "_NETWORK_ROUTERS_combinedScript" + ".R";
        NetDecoderUtils.combineFiles(Rscripts, scriptName);
        try {
            Runtime.getRuntime().exec("R --slave --no-save CMD BATCH " + scriptName);
        }
        catch (IOException io) {
            System.out.println(io.getMessage());
        }
        this.impactScore(path2create);
    }

    public Map<String, Map<String, Double>> getFlowInNetworks(Map<String, Node> controlNetwork, Map<String, Node> diseaseNetwork) {
        LinkedHashSet<String> allGenes = new LinkedHashSet<String>(diseaseNetwork.keySet());
        allGenes.addAll(controlNetwork.keySet());
        LinkedHashMap<String, Map<String, Double>> flows = new LinkedHashMap<String, Map<String, Double>>();
        for (String gene : allGenes) {
            LinkedHashMap<String, Double> tmp = new LinkedHashMap<String, Double>();
            if (diseaseNetwork.containsKey(gene) && controlNetwork.containsKey(gene)) {
                Double difference = diseaseNetwork.get(gene).getTotalFlow() - controlNetwork.get(gene).getTotalFlow();
                tmp.put("control", controlNetwork.get(gene).getTotalFlow());
                tmp.put("disease", diseaseNetwork.get(gene).getTotalFlow());
                tmp.put("difference", difference);
            } else if (diseaseNetwork.containsKey(gene)) {
                tmp.put("control", 0.0);
                tmp.put("disease", diseaseNetwork.get(gene).getTotalFlow());
                tmp.put("difference", diseaseNetwork.get(gene).getTotalFlow());
            } else {
                tmp.put("control", controlNetwork.get(gene).getTotalFlow());
                tmp.put("disease", 0.0);
                tmp.put("difference", controlNetwork.get(gene).getTotalFlow());
            }
            flows.put(gene, tmp);
        }
        return flows;
    }

    public Set<String> prioritizeSinks(Map<String, Node> controlNetwork, Map<String, Node> diseaseNetwork, String condition, int topSinks, RJava rJava, String filename, List<String> Rscripts) throws IOException {
        Map<String, Map<String, Double>> flowInNetworks = this.getFlowInNetworks(controlNetwork, diseaseNetwork);
        Map<String, Double> controlSinksMap = NetDecoderUtils.getSinks(controlNetwork);
        Map<String, Double> diseaseSinksMap = NetDecoderUtils.getSinks(diseaseNetwork);
        LinkedHashSet<String> allSinks = new LinkedHashSet<String>(controlSinksMap.keySet());
        allSinks.addAll(diseaseSinksMap.keySet());
        Map<String, Double> flowDifference = NetDecoderUtils.getFlowDifference(flowInNetworks, allSinks);
        Map<String, Double> sortedScores = NetworkFlow.sortByValues(flowDifference);
        ArrayList<String> aux = new ArrayList<String>(sortedScores.keySet());
        List topGenes_down = aux.subList(0, topSinks);
        List topGenes_up = aux.subList(aux.size() - topSinks, aux.size());
        ArrayList topGenes = new ArrayList(topGenes_down);
        topGenes.addAll(topGenes_up);
        LinkedHashMap<String, Double> topGenesScores = new LinkedHashMap<String, Double>();
        for (String g : topGenes) {
            if (sortedScores.get(g) > 0.0) {
                topGenesScores.put(g, Math.log10(sortedScores.get(g)));
                continue;
            }
            double tmp = -Math.log10(Math.abs(sortedScores.get(g)));
            topGenesScores.put(g, tmp);
        }
        String name = filename + "_SINKS";
        NetDecoderUtils.saveFlows(topGenesScores, name + ".txt");
        String heatmap = rJava.createHeatmapSH2Script(name, condition, topSinks, "Key targets", filename);
        Rscripts.add(heatmap);
        Map<String, Double> totalFlowsDisease = NetDecoderUtils.getTotalFlow(diseaseNetwork);
        Map<String, Double> totalFlowsControl = NetDecoderUtils.getTotalFlow(controlNetwork);
        for (String gene : topGenesScores.keySet()) {
            if (controlNetwork.containsKey(gene)) {
                ArrayList<Edge> controlEdges = controlNetwork.get(gene).getEdges();
                Map<String, Node> cNet = NetDecoderUtils.createMotifTargets(gene, controlEdges);
                new NetworkFlow().saveSubNet(cNet, filename + "_" + gene + "_KT_Control.txt");
                Map<String, Double> controlDiff = NetDecoderUtils.getFlowDifference(flowInNetworks, cNet.keySet());
                Map<String, Double> controlTotal = NetDecoderUtils.getTotalFlowInProteins(totalFlowsControl, cNet.keySet());
                Map<String, Double> controlEdgesFlow = this.getEdgeFlow(cNet);
                NetDecoderUtils.saveFlows(controlTotal, filename + "_" + gene + "_KT_totalFlow_Control.txt");
                NetDecoderUtils.saveFlows(controlDiff, filename + "_" + gene + "_KT_flowDifference_Control.txt");
                NetDecoderUtils.saveFlows(controlEdgesFlow, filename + "_" + gene + "_KT_edge_flows_Control.txt");
                String gmlControl = rJava.createScriptExportGML2(filename + "_" + gene + "_KT_Control", filename + "_" + gene + "_KT_totalFlow_Control", filename + "_" + gene + "_KT_flowDifference_Control");
                String distrControl = rJava.createDistributionScript(filename + "_" + gene + "_KT_edge_flows_Control", "Control");
                Rscripts.add(gmlControl);
                Rscripts.add(distrControl);
            }
            if (!diseaseNetwork.containsKey(gene)) continue;
            ArrayList<Edge> diseaseEdges = diseaseNetwork.get(gene).getEdges();
            Map<String, Node> dNet = NetDecoderUtils.createMotifTargets(gene, diseaseEdges);
            new NetworkFlow().saveSubNet(dNet, filename + "_" + gene + "_KT_Disease.txt");
            Map<String, Double> diseaseDiff = NetDecoderUtils.getFlowDifference(flowInNetworks, dNet.keySet());
            Map<String, Double> diseaseTotal = NetDecoderUtils.getTotalFlowInProteins(totalFlowsDisease, dNet.keySet());
            Map<String, Double> diseaseEdgesFlow = this.getEdgeFlow(dNet);
            NetDecoderUtils.saveFlows(diseaseTotal, filename + "_" + gene + "_KT_totalFlow_Disease.txt");
            NetDecoderUtils.saveFlows(diseaseDiff, filename + "_" + gene + "_KT_flowDifference_Disease.txt");
            NetDecoderUtils.saveFlows(diseaseEdgesFlow, filename + "_" + gene + "_KT_edge_flows_Disease.txt");
            String gmlDisease = rJava.createScriptExportGML2(filename + "_" + gene + "_KT_Disease", filename + "_" + gene + "_KT_totalFlow_Disease", filename + "_" + gene + "_KT_flowDifference_Disease");
            String distrDisease = rJava.createDistributionScript(filename + "_" + gene + "_KT_edge_flows_Disease", condition);
            Rscripts.add(gmlDisease);
            Rscripts.add(distrDisease);
        }
        return topGenesScores.keySet();
    }

    public Set<String> prioritizeHiddenProteins(Map<String, Node> controlNetwork, Map<String, Node> diseaseNetwork, String condition, int topHidden, RJava rJava, String filename, List<String> Rscripts) throws IOException {
        Map<String, Map<String, Double>> flowInNetworks = this.getFlowInNetworks(controlNetwork, diseaseNetwork);
        Map<String, Double> hiddenProteinsControl = NetDecoderUtils.getHiddenProteins(controlNetwork);
        Map<String, Double> hiddenProteinsDisease = NetDecoderUtils.getHiddenProteins(diseaseNetwork);
        LinkedHashSet<String> allHidden = new LinkedHashSet<String>(hiddenProteinsControl.keySet());
        allHidden.addAll(hiddenProteinsDisease.keySet());
        Map<String, Double> flowDifference = NetDecoderUtils.getFlowDifference(flowInNetworks, allHidden);
        Map<String, Double> sortedScores = NetworkFlow.sortByValues(flowDifference);
        ArrayList<String> aux = new ArrayList<String>(sortedScores.keySet());
        List topGenes_down = aux.subList(0, topHidden);
        List topGenes_up = aux.subList(aux.size() - topHidden, aux.size());
        ArrayList topGenes = new ArrayList(topGenes_down);
        topGenes.addAll(topGenes_up);
        LinkedHashMap<String, Double> topGenesScores = new LinkedHashMap<String, Double>();
        for (String g : topGenes) {
            if (sortedScores.get(g) > 0.0) {
                topGenesScores.put(g, Math.log10(sortedScores.get(g)));
                continue;
            }
            double tmp = -Math.log10(Math.abs(sortedScores.get(g)));
            topGenesScores.put(g, tmp);
        }
        String name = filename + "_HIDDEN";
        NetDecoderUtils.saveFlows(topGenesScores, name + ".txt");
        String heatmap = rJava.createHeatmapSH2Script(name, condition, topHidden, "Network routers", filename);
        Rscripts.add(heatmap);
        Map<String, Double> totalFlowsDisease = NetDecoderUtils.getTotalFlow(diseaseNetwork);
        Map<String, Double> totalFlowsControl = NetDecoderUtils.getTotalFlow(controlNetwork);
        for (String gene : topGenesScores.keySet()) {
            if (controlNetwork.containsKey(gene)) {
                ArrayList<Edge> controlEdges = controlNetwork.get(gene).getEdges();
                Map<String, Node> cNet = NetDecoderUtils.createMotifNetworkRouters(gene, controlEdges);
                new NetworkFlow().saveSubNet(cNet, filename + "_" + gene + "_NR_Control.txt");
                Map<String, Double> controlDiff = NetDecoderUtils.getFlowDifference(flowInNetworks, cNet.keySet());
                Map<String, Double> controlTotal = NetDecoderUtils.getTotalFlowInProteins(totalFlowsControl, cNet.keySet());
                Map<String, Double> controlEdgesFlow = this.getEdgeFlow(cNet);
                NetDecoderUtils.saveFlows(controlTotal, filename + "_" + gene + "_NR_totalFlow_Control.txt");
                NetDecoderUtils.saveFlows(controlDiff, filename + "_" + gene + "_NR_flowDifference_Control.txt");
                NetDecoderUtils.saveFlows(controlEdgesFlow, filename + "_" + gene + "_NR_edge_flows_Control.txt");
                String gmlControl = rJava.createScriptExportGML2(filename + "_" + gene + "_NR_Control", filename + "_" + gene + "_NR_totalFlow_Control", filename + "_" + gene + "_NR_flowDifference_Control");
                String distrControl = rJava.createDistributionScript(filename + "_" + gene + "_NR_edge_flows_Control", "Control");
                Rscripts.add(gmlControl);
                Rscripts.add(distrControl);
            }
            if (!diseaseNetwork.containsKey(gene)) continue;
            ArrayList<Edge> diseaseEdges = diseaseNetwork.get(gene).getEdges();
            Map<String, Node> dNet = NetDecoderUtils.createMotifNetworkRouters(gene, diseaseEdges);
            new NetworkFlow().saveSubNet(dNet, filename + "_" + gene + "_NR_Disease.txt");
            Map<String, Double> diseaseDiff = NetDecoderUtils.getFlowDifference(flowInNetworks, dNet.keySet());
            Map<String, Double> diseaseTotal = NetDecoderUtils.getTotalFlowInProteins(totalFlowsDisease, dNet.keySet());
            Map<String, Double> diseaseEdgesFlow = this.getEdgeFlow(dNet);
            NetDecoderUtils.saveFlows(diseaseTotal, filename + "_" + gene + "_NR_totalFlow_Disease.txt");
            NetDecoderUtils.saveFlows(diseaseDiff, filename + "_" + gene + "_NR_flowDifference_Disease.txt");
            NetDecoderUtils.saveFlows(diseaseEdgesFlow, filename + "_" + gene + "_NR_edge_flows_Disease.txt");
            String gmlDisease = rJava.createScriptExportGML2(filename + "_" + gene + "_NR_Disease", filename + "_" + gene + "_NR_totalFlow_Disease", filename + "_" + gene + "_NR_flowDifference_Disease");
            String distrDisease = rJava.createDistributionScript(filename + "_" + gene + "_NR_edge_flows_Disease", condition);
            Rscripts.add(gmlDisease);
            Rscripts.add(distrDisease);
        }
        return topGenesScores.keySet();
    }

    public void prioritizePaths(List<String> controlPaths, List<String> diseasePaths, Map<String, Double> totalFlows, Map<String, Map<String, Double>> flowDifference, Set<String> sinks, Set<String> hidden, Set<String> IPgenes, RJava rJava, String filename, List<String> Rscripts) throws IOException {
        sinks.removeAll(IPgenes);
        hidden.removeAll(IPgenes);
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        for (String p : diseasePaths) {
            Path path = NetDecoderUtils.convertString2Path(p);
            boolean flag = false;
            for (Edge e : path.getPath()) {
                Node from = e.getFrom();
                Node to = e.getTo();
                if (sinks.contains(to.getName()) && (hidden.contains(from.getName()) || hidden.contains(to.getName()))) {
                    flag = true;
                    break;
                }
                if (sinks.contains(to.getName()) && (IPgenes.contains(from.getName()) || IPgenes.contains(to.getName()))) {
                    flag = true;
                    break;
                }
                if (!hidden.contains(from.getName()) && !hidden.contains(to.getName()) || !IPgenes.contains(from.getName()) && !IPgenes.contains(to.getName())) continue;
                flag = true;
                break;
            }
            if (!flag) continue;
            paths.add(path);
        }
        List<String> tmpPaths = NetDecoderUtils.convertPaths2String(new ArrayList<Path>(paths));
        Map<String, Node> network = NetDecoderUtils.createNetworkFromPaths2Plot(tmpPaths);
        Map<String, Double> flowDiff = NetDecoderUtils.getFlowDifference(flowDifference, network.keySet());
        Map<String, Double> flowTotal = NetDecoderUtils.getTotalFlowInProteins(totalFlows, network.keySet());
        if (!network.isEmpty()) {
            new NetworkFlow().saveSubNet(network, filename + "_PRIORITIZED_NETWORK.txt");
            NetDecoderUtils.saveFlows(flowDiff, filename + "_flowDifference_PRIORITIZED_NETWORK.txt");
            NetDecoderUtils.saveFlows(flowTotal, filename + "_flowTotal_PRIORITIZED_NETWORK.txt");
            String gml1 = rJava.createScriptExportGML(filename + "_PRIORITIZED_NETWORK", filename + "_flowTotal_PRIORITIZED_NETWORK", filename + "_flowDifference_PRIORITIZED_NETWORK");
            Rscripts.add(gml1);
        } else {
            System.out.println("No paths fulfill the criteria to be be prioritized!");
        }
    }

    public void prioritizePaths(List<String> controlPaths, List<String> diseasePaths, Map<Edge, List<Path>> diseaseEdges2Path, Map<Edge, List<Path>> controlEdges2Path, Map<String, Double> totalFlows, Map<String, Map<String, Double>> flowDifference, Set<String> sinks, Set<String> hidden, boolean includeKeyEdges, RJava rJava, String filename) throws IOException {
        LinkedHashSet<Object> paths = new LinkedHashSet<Object>();
        LinkedHashSet<Path> pathsFilteredByEdges = new LinkedHashSet<Path>();
        for (String p : diseasePaths) {
            Path path = NetDecoderUtils.convertString2Path(p);
            boolean bl = false;
            for (Edge e : path.getPath()) {
                Node from = e.getFrom();
                Node to = e.getTo();
                if (!sinks.contains(to.getName()) || !hidden.contains(from.getName()) && !hidden.contains(to.getName())) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            paths.add(path);
        }
        if (includeKeyEdges) {
            for (Edge key : diseaseEdges2Path.keySet()) {
                for (Path path : paths) {
                    if (!path.getPath().contains(key)) continue;
                    pathsFilteredByEdges.add(path);
                }
            }
        }
        LinkedHashSet<Object> aux = null;
        aux = includeKeyEdges ? pathsFilteredByEdges : paths;
        List<String> tmpPaths = NetDecoderUtils.convertPaths2String(new ArrayList<Path>(aux));
        Map<String, Node> network = NetDecoderUtils.createNetworkFromPaths(tmpPaths);
        Map<String, Double> map = NetDecoderUtils.getFlowDifference(flowDifference, network.keySet());
        Map<String, Double> flowTotal = NetDecoderUtils.getTotalFlowInProteins(totalFlows, network.keySet());
        if (!network.isEmpty()) {
            new NetworkFlow().saveSubNet(network, filename + "_prioritizedNetwork.txt");
            NetDecoderUtils.saveFlows(map, filename + "_flowDifference_prioritizedNetwork.txt");
            NetDecoderUtils.saveFlows(flowTotal, filename + "_flowTotal_prioritizedNetwork.txt");
            rJava.exportGML(filename + "_prioritizedNetwork", filename + "_flowTotal_prioritizedNetwork", filename + "_flowDifference_prioritizedNetwork");
        } else {
            System.out.println("No paths fulfill the criteria to be be prioritized!");
        }
    }

    public void DFNAnalysis(List<String> controlPaths, List<String> diseasePaths) throws IOException {
        List<Path> diseaseSpecPaths = NetDecoderUtils.getPhenotypeSpecificPaths(diseasePaths, controlPaths);
        List<Path> controlSpecPaths = NetDecoderUtils.getPhenotypeSpecificPaths(controlPaths, diseasePaths);
        System.out.println(diseaseSpecPaths.size());
        System.out.println(diseasePaths.size());
        System.out.println(controlSpecPaths.size());
        System.out.println(controlPaths.size());
        List<String> sDiseasePaths = NetDecoderUtils.transformPaths2String(diseaseSpecPaths);
        List<String> sControlPaths = NetDecoderUtils.transformPaths2String(controlSpecPaths);
        Map<String, Node> diseaseNetwork = NetDecoderUtils.createNetworkFromPaths(sDiseasePaths);
        Map<String, Node> controlNetwork = NetDecoderUtils.createNetworkFromPaths(sControlPaths);
        System.out.println(diseaseNetwork.size());
        System.out.println(controlNetwork.size());
        LinkedHashSet<String> genesDisease = new LinkedHashSet<String>(diseaseNetwork.keySet());
        LinkedHashSet<String> genesControl = new LinkedHashSet<String>(controlNetwork.keySet());
        genesDisease.removeAll(controlNetwork.keySet());
        genesControl.removeAll(diseaseNetwork.keySet());
        System.out.println("GENES: " + genesDisease.size());
        System.out.println("GENES: " + genesControl.size());
        Collections.sort(diseaseSpecPaths, (p1, p2) -> Double.compare(p1.flow, p2.flow));
        Collections.sort(controlSpecPaths, (p1, p2) -> Double.compare(p1.flow, p2.flow));
        NetDecoderUtils.savePaths(diseaseSpecPaths, "TEST_DFN_paths_disease.txt");
        NetDecoderUtils.savePaths(controlSpecPaths, "TEST_DFN_paths_control.txt");
    }

    public static void main(String[] args) throws IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        try {
            NetDecoder pn = new NetDecoder();
            if (pn.checkArgs(args)) {
                pn.runAnalysis();
            } else {
                System.out.println("ferrou");
            }
        }
        catch (Throwable t) {
            System.err.println("Uncaught exception - " + t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    public List<String> setDefaultSinks() {
        ArrayList<String> TFAnnot = new ArrayList<String>();
        TFAnnot.add("GO:0003676");
        TFAnnot.add("GO:0006355");
        TFAnnot.add("GO:0008134");
        return TFAnnot;
    }
}

